// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIScript;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.ScriptTagDeclaration}.
 */
public final class ScriptTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(ScriptTag.class);
  private javax.el.ValueExpression  file;
  private javax.el.ValueExpression  onunload;
  private javax.el.ValueExpression  onexit;
  private javax.el.ValueExpression  onsubmit;
  private javax.el.ValueExpression  script;
  private javax.el.ValueExpression  onload;

  @Override
  public String getComponentType() {
    return UIScript.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Script";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIScript component = (UIScript) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (file != null) {
      component.setValueExpression("file", file);
    }

    if (onunload != null) {
      component.setValueExpression("onunload", onunload);
    }

    if (onexit != null) {
      component.setValueExpression("onexit", onexit);
    }

    if (onsubmit != null) {
      component.setValueExpression("onsubmit", onsubmit);
    }

    if (script != null) {
      component.setValueExpression("script", script);
    }

    if (onload != null) {
      component.setValueExpression("onload", onload);
    }

  }

  public javax.el.ValueExpression getFile() {
    return file;
  }

  public void setFile(final javax.el.ValueExpression file) {
    this.file = file;
  }

  public javax.el.ValueExpression getOnunload() {
    return onunload;
  }

  public void setOnunload(final javax.el.ValueExpression onunload) {
    this.onunload = onunload;
  }

  public javax.el.ValueExpression getOnexit() {
    return onexit;
  }

  public void setOnexit(final javax.el.ValueExpression onexit) {
    this.onexit = onexit;
  }

  public javax.el.ValueExpression getOnsubmit() {
    return onsubmit;
  }

  public void setOnsubmit(final javax.el.ValueExpression onsubmit) {
    this.onsubmit = onsubmit;
  }

  public javax.el.ValueExpression getScript() {
    return script;
  }

  public void setScript(final javax.el.ValueExpression script) {
    this.script = script;
  }

  public javax.el.ValueExpression getOnload() {
    return onload;
  }

  public void setOnload(final javax.el.ValueExpression onload) {
    this.onload = onload;
  }


  @Override
  public int doAfterBody() throws javax.servlet.jsp.JspException {
    final String content = bodyContent.getString();
    bodyContent.clearBody();
    if (StringUtils.isNotBlank(content)) {
      final UIScript component = (UIScript) getComponentInstance();
      component.setScript(content.trim());
    }
    return super.doAfterBody();
  }

  @Override
  public void release() {
    super.release();
    file = null;
    onunload = null;
    onexit = null;
    onsubmit = null;
    script = null;
    onload = null;
  }
}