/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Orientation;

public abstract class AbstractUISplitLayout
extends AbstractUIGridLayout {
    public static final String VERTICAL = Orientation.VERTICAL.name();
    public static final String HORIZONTAL = Orientation.HORIZONTAL.name();
    private String submittedLayout;

    public void updateLayout(int position) {
        int currentSize2;
        int currentSize1;
        int oldPosition;
        LayoutContainer container = (LayoutContainer)this.getParent();
        LayoutComponent firstComponent = container.getComponents().get(0);
        LayoutComponent secondComponent = container.getComponents().get(1);
        if (HORIZONTAL.equals(this.getOrientation())) {
            oldPosition = secondComponent.getLeft().getPixel() - 5;
            currentSize1 = firstComponent.getCurrentWidth().getPixel();
            currentSize2 = secondComponent.getCurrentWidth().getPixel();
        } else {
            oldPosition = secondComponent.getTop().getPixel() - 5;
            currentSize1 = firstComponent.getCurrentHeight().getPixel();
            currentSize2 = secondComponent.getCurrentHeight().getPixel();
        }
        int offset = position - oldPosition;
        int newSize1 = currentSize1 + offset;
        int newSize2 = currentSize2 - offset;
        int ggt = AbstractUISplitLayout.gcd(newSize1, newSize2);
        this.submittedLayout = Integer.toString(newSize1 / ggt) + "*;" + Integer.toString(newSize2 / ggt) + "*";
    }

    public static int gcd(int aParameter, int bParameter) {
        int a = aParameter;
        int b = bParameter;
        if (a < 0) {
            a = -a;
        }
        if (b < 0) {
            b = -b;
        }
        while (b != 0) {
            int t = a % b;
            a = b;
            b = t;
        }
        return a;
    }

    public void processUpdates(FacesContext facesContext) {
        this.updateModel(facesContext);
        super.processUpdates(facesContext);
    }

    private void updateModel(FacesContext facesContext) {
        ValueExpression expression;
        if (this.submittedLayout != null && (expression = this.getValueExpression("layout")) != null) {
            ELContext elContext = facesContext.getELContext();
            expression.setValue(elContext, (Object)this.submittedLayout);
            this.submittedLayout = null;
        }
    }

    @Override
    public Measure getSpacing(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.getColumnSpacing() : this.getRowSpacing();
    }

    @Override
    public void setColumns(String columns) {
    }

    @Override
    public String getColumns() {
        return VERTICAL.equals(this.getOrientation()) ? "1*" : this.getLayout2();
    }

    @Override
    public void setRows(String rows) {
    }

    @Override
    public String getRows() {
        return HORIZONTAL.equals(this.getOrientation()) ? "1*" : this.getLayout2();
    }

    private String getLayout2() {
        return this.submittedLayout != null ? this.submittedLayout : this.getLayout();
    }

    @Override
    public boolean isRowOverflow() {
        return false;
    }

    @Override
    public boolean isColumnOverflow() {
        return false;
    }

    public abstract String getLayout();

    public abstract String getOrientation();

    @Override
    @Deprecated
    public abstract Measure getCellspacing();

    @Override
    public abstract Measure getRowSpacing();

    @Override
    public abstract Measure getColumnSpacing();

    @Override
    public abstract Measure getMarginLeft();

    @Override
    public abstract Measure getMarginTop();

    @Override
    public abstract Measure getMarginRight();

    @Override
    public abstract Measure getMarginBottom();

    @Override
    public abstract boolean isRigid();
}

