/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.internal.config.ThemeBuilder;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.apache.myfaces.tobago.internal.context.ResourceLocator;
import org.apache.myfaces.tobago.internal.context.ResourceManagerImpl;

public final class ResourceManagerFactory {
    public static final String RESOURCE_MANAGER = "org.apache.myfaces.tobago.context.ResourceManager";
    private static boolean initialized;

    private ResourceManagerFactory() {
    }

    public static ResourceManager getResourceManager(FacesContext facesContext) {
        assert (initialized);
        return (ResourceManager)facesContext.getExternalContext().getApplicationMap().get(RESOURCE_MANAGER);
    }

    public static ResourceManager getResourceManager(ServletContext servletContext) {
        assert (initialized);
        return (ResourceManager)servletContext.getAttribute(RESOURCE_MANAGER);
    }

    public static void init(ServletContext servletContext, TobagoConfigImpl tobagoConfig) throws ServletException {
        assert (!initialized);
        ResourceManagerImpl resourceManager = new ResourceManagerImpl(tobagoConfig);
        ThemeBuilder themeBuilder = new ThemeBuilder(tobagoConfig);
        ResourceLocator resourceLocator = new ResourceLocator(servletContext, resourceManager, themeBuilder);
        resourceLocator.locate();
        themeBuilder.resolveThemes();
        servletContext.setAttribute(RESOURCE_MANAGER, (Object)resourceManager);
        initialized = true;
    }

    public static void release(ServletContext servletContext) {
        assert (initialized);
        initialized = false;
        servletContext.removeAttribute(RESOURCE_MANAGER);
    }
}

