/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.css;

import java.util.regex.Pattern;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Icons implements CssItem
{
    ANGLE_DOUBLE_LEFT,
    ANGLE_DOUBLE_RIGHT,
    ANGLE_DOWN,
    ANGLE_LEFT,
    ANGLE_RIGHT,
    ANGLE_UP,
    BACKWARD,
    BARS,
    CALENDAR,
    CLOCK_O,
    ELLIPSIS_H,
    EXCLAMATION,
    FOLDER_OPEN,
    FORWARD,
    MINUS_SQUARE_O,
    PLUS_SQUARE_O,
    QUESTION,
    SQUARE_O,
    STEP_BACKWARD,
    STEP_FORWARD;

    private static final Logger LOG;
    public static final CssItem FA;
    private static final Pattern PATTERN;
    private String fa = "fa-" + this.name().toLowerCase().replaceAll("_", "-");

    @Override
    public String getName() {
        return this.fa;
    }

    public static CssItem custom(final String name) {
        return new CssItem(){

            @Override
            public String getName() {
                if (PATTERN.matcher(name).matches()) {
                    return name;
                }
                LOG.warn("Unknown Icon: '" + name + "'");
                return null;
            }
        };
    }

    static {
        LOG = LoggerFactory.getLogger(Icons.class);
        FA = new CssItem(){

            @Override
            public String getName() {
                return "fa";
            }
        };
        PATTERN = Pattern.compile("^(fa(-[a-z]+)+)$");
    }
}

