/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingMdcFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingMdcFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (LOG.isInfoEnabled()) {
            LOG.info("init " + this.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (request instanceof HttpServletRequest) {
                String remoteUser;
                String remoteAddr;
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpSession session = httpRequest.getSession(false);
                if (session != null) {
                    MDC.put((String)"sessionId", (String)session.getId());
                }
                if ((remoteAddr = httpRequest.getRemoteAddr()) != null) {
                    MDC.put((String)"ip", (String)remoteAddr);
                }
                if ((remoteUser = httpRequest.getRemoteUser()) != null) {
                    MDC.put((String)"user", (String)remoteUser);
                }
            }
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
        }
    }

    public void destroy() {
    }
}

