/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeSource;
import org.apache.myfaces.tobago.event.ValueExpressionTabChangeListener;

public class TabChangeListenerHandler
extends TagHandler {
    private Class listenerType;
    private final TagAttribute type;
    private final TagAttribute binding = this.getAttribute("binding");

    public TabChangeListenerHandler(TagConfig config) {
        super(config);
        this.type = this.getAttribute("type");
        if (this.type != null) {
            if (!this.type.isLiteral()) {
                throw new TagAttributeException(this.tag, this.type, "Must be literal");
            }
            try {
                this.listenerType = Class.forName(this.type.getValue());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.tag, this.type, (Throwable)e);
            }
        }
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException {
        if (parent instanceof TabChangeSource) {
            if (parent.getParent() == null) {
                TabChangeSource changeSource = (TabChangeSource)parent;
                TabChangeListener listener = null;
                ValueExpression valueExpression = null;
                if (this.binding != null) {
                    valueExpression = this.binding.getValueExpression(faceletContext, TabChangeListener.class);
                    listener = (TabChangeListener)valueExpression.getValue((ELContext)faceletContext);
                }
                if (listener == null) {
                    try {
                        listener = (TabChangeListener)this.listenerType.newInstance();
                    }
                    catch (Exception e) {
                        throw new TagAttributeException(this.tag, this.type, (Throwable)e);
                    }
                    if (valueExpression != null) {
                        valueExpression.setValue((ELContext)faceletContext, (Object)listener);
                    }
                }
                if (valueExpression != null) {
                    changeSource.addTabChangeListener(new ValueExpressionTabChangeListener(this.type.getValue(), valueExpression));
                } else {
                    changeSource.addTabChangeListener(listener);
                }
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type TabChangeSource, type is: " + parent);
        }
    }
}

