/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeIcon;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeIconRenderer<T extends AbstractUITreeIcon>
extends RendererBase<T> {
    @Deprecated
    protected static final String OPEN_FOLDER = "image/treeNode-icon-open";
    @Deprecated
    protected static final String CLOSED_FOLDER = "image/treeNode-icon";
    @Deprecated
    protected static final String LEAF = "image/treeNode-icon-leaf";

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        AbstractUIData data = ComponentUtils.findAncestor(component, AbstractUIData.class);
        AbstractUITreeNode node = ComponentUtils.findAncestor(component, AbstractUITreeNode.class);
        boolean folder = node.isFolder();
        boolean expanded = folder && data.getExpandedState().isExpanded(node.getPath());
        String value = (String)component.getValue();
        String closed = ((AbstractUITreeIcon)component).getClosed();
        String open = ((AbstractUITreeIcon)component).getOpen();
        if (closed == null) {
            closed = value;
        }
        if (open == null) {
            open = closed;
        }
        String source = folder ? (expanded ? open : closed) : value;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SPAN);
        writer.writeIdAttribute(component.getClientId());
        writer.writeClassAttribute(TobagoClass.TOGGLE, component.getCustomClass());
        if (Icons.matches(source)) {
            writer.startElement(HtmlElements.I);
            writer.writeClassAttribute(Icons.custom(source));
            if (folder) {
                writer.writeAttribute(DataAttributes.OPEN, open, true);
                writer.writeAttribute(DataAttributes.CLOSED, closed, true);
            }
            writer.endElement(HtmlElements.I);
        } else {
            writer.startElement(HtmlElements.IMG);
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
            writer.writeAttribute(HtmlAttributes.SRC, source, true);
            if (folder) {
                writer.writeAttribute(DataAttributes.OPEN, open, true);
                writer.writeAttribute(DataAttributes.CLOSED, closed, true);
            }
            writer.writeAttribute(HtmlAttributes.ALT, "", false);
            writer.endElement(HtmlElements.IMG);
        }
        writer.endElement(HtmlElements.SPAN);
    }
}

