/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUIStars;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecorationPositionRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class StarsRenderer<T extends AbstractUIStars>
extends DecorationPositionRendererBase<T> {
    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUIInput)component).isDisabled() || ((AbstractUIInput)component).isReadonly();
    }

    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_STARS;
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUIInput)component).getFieldId(facesContext);
        String hiddenInputId = clientId + "::input";
        String sliderId = clientId + "::slider";
        int value = ((AbstractUIStars)component).getRangeValue();
        int max = ((AbstractUIStars)component).getRangeMax();
        Double placeholder = ((AbstractUIStars)component).getPlaceholder();
        boolean readonly = ((AbstractUIInput)component).isReadonly();
        boolean disabled = ((AbstractUIInput)component).isDisabled();
        boolean required = component.isRequired();
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        String sliderValue = component.getSubmittedValue() != null ? (String)component.getSubmittedValue() : String.valueOf(value);
        String hiddenInputValue = required && "0".equals(sliderValue) ? null : sliderValue;
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(fieldId);
        writer.writeClassAttribute(TobagoClass.STARS, component.getCustomClass());
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(hiddenInputId);
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, hiddenInputValue, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__CONTAINER);
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(sliderId);
        writer.writeNameAttribute(clientId);
        writer.writeClassAttribute(TobagoClass.STARS__SLIDER);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, readonly || disabled ? HtmlInputTypes.HIDDEN : HtmlInputTypes.RANGE);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MIN, required ? 1 : 0);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAX, max);
        writer.writeAttribute(HtmlAttributes.VALUE, sliderValue, true);
        if (placeholder != null) {
            writer.writeAttribute(HtmlAttributes.PLACEHOLDER, placeholder.toString(), true);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
        StarsRenderer.renderFocus(clientId, ((AbstractUIInput)component).isFocus(), ((AbstractUIInput)component).isError(), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUIInput)component).getTabIndex());
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.endElement(HtmlElements.INPUT);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.STARS__FOCUS_BOX);
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__TOOLTIP, BootstrapClass.FADE);
        writer.endElement(HtmlElements.SPAN);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__SELECTED);
        writer.endElement(HtmlElements.SPAN);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__UNSELECTED);
        writer.endElement(HtmlElements.SPAN);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__PRESELECTED);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.SPAN);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUIInput)component).getFieldId(facesContext);
    }
}

