/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class Any2LsRGBRed
extends AbstractRed {
    boolean srcIssRGB = false;
    private static final double GAMMA = 2.4;
    private static final double LFACT = 0.07739938080495357;
    private static final int[] sRGBToLsRGBLut = new int[256];

    public Any2LsRGBRed(CachableRed cachableRed) {
        super(cachableRed, cachableRed.getBounds(), Any2LsRGBRed.fixColorModel(cachableRed), Any2LsRGBRed.fixSampleModel(cachableRed), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel == null) {
            return;
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1000)) {
            this.srcIssRGB = true;
        }
    }

    public static final double sRGBToLsRGB(double d) {
        if (d <= 0.003928) {
            return d * 0.07739938080495357;
        }
        return Math.pow((d + 0.055) / 1.055, 2.4);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        ColorModel colorModel = cachableRed.getColorModel();
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (this.srcIssRGB && Any2sRGBRed.is_INT_PACK_COMP(writableRaster.getSampleModel())) {
            cachableRed.copyData(writableRaster);
            if (colorModel.hasAlpha()) {
                GraphicsUtil.coerceData(writableRaster, colorModel, false);
            }
            Any2sRGBRed.applyLut_INT(writableRaster, sRGBToLsRGBLut);
            return writableRaster;
        }
        if (colorModel == null) {
            float[][] fArray = null;
            switch (sampleModel.getNumBands()) {
                case 1: {
                    fArray = new float[1][3];
                    fArray[0][0] = 1.0f;
                    fArray[0][1] = 1.0f;
                    fArray[0][2] = 1.0f;
                    break;
                }
                case 2: {
                    fArray = new float[2][4];
                    fArray[0][0] = 1.0f;
                    fArray[0][1] = 1.0f;
                    fArray[0][2] = 1.0f;
                    fArray[1][3] = 1.0f;
                    break;
                }
                case 3: {
                    fArray = new float[3][3];
                    fArray[0][0] = 1.0f;
                    fArray[1][1] = 1.0f;
                    fArray[2][2] = 1.0f;
                    break;
                }
                default: {
                    fArray = new float[sampleModel.getNumBands()][4];
                    fArray[0][0] = 1.0f;
                    fArray[1][1] = 1.0f;
                    fArray[2][2] = 1.0f;
                    fArray[3][3] = 1.0f;
                }
            }
            Raster raster = cachableRed.getData(writableRaster.getBounds());
            BandCombineOp bandCombineOp = new BandCombineOp(fArray, null);
            bandCombineOp.filter(raster, writableRaster);
        } else {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            BufferedImage bufferedImage;
            ColorModel colorModel2 = this.getColorModel();
            if (!colorModel2.hasAlpha()) {
                bufferedImage = new BufferedImage(colorModel2, writableRaster.createWritableTranslatedChild(0, 0), colorModel2.isAlphaPremultiplied(), null);
            } else {
                object4 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
                object3 = ((SinglePixelPackedSampleModel)object4).getBitMasks();
                object2 = new SinglePixelPackedSampleModel(((SampleModel)object4).getDataType(), ((SampleModel)object4).getWidth(), ((SampleModel)object4).getHeight(), ((SinglePixelPackedSampleModel)object4).getScanlineStride(), new int[]{object3[0], object3[1], (int)object3[2]});
                object = GraphicsUtil.Linear_sRGB;
                WritableRaster writableRaster2 = Raster.createWritableRaster((SampleModel)object2, writableRaster.getDataBuffer(), new Point(0, 0));
                writableRaster2 = writableRaster2.createWritableChild(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, null);
                bufferedImage = new BufferedImage((ColorModel)object, writableRaster2, false, null);
            }
            object4 = colorModel;
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                object2 = writableRaster.getBounds();
                object = colorModel.createCompatibleSampleModel(((Rectangle)object2).width, ((Rectangle)object2).height);
                object3 = Raster.createWritableRaster((SampleModel)object, new Point(((Rectangle)object2).x, ((Rectangle)object2).y));
                cachableRed.copyData((WritableRaster)object3);
                object4 = GraphicsUtil.coerceData((WritableRaster)object3, colorModel, false);
            } else {
                object2 = cachableRed.getData(writableRaster.getBounds());
                object3 = GraphicsUtil.makeRasterWritable((Raster)object2);
            }
            object2 = new BufferedImage((ColorModel)object4, ((WritableRaster)object3).createWritableTranslatedChild(0, 0), false, null);
            object = new ColorConvertOp(null);
            ((ColorConvertOp)object).filter((BufferedImage)object2, bufferedImage);
            if (colorModel2.hasAlpha()) {
                AbstractRed.copyBand((Raster)object3, sampleModel.getNumBands() - 1, writableRaster, this.getSampleModel().getNumBands() - 1);
            }
        }
        return writableRaster;
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel != null) {
            if (colorModel.hasAlpha()) {
                return GraphicsUtil.Linear_sRGB_Unpre;
            }
            return GraphicsUtil.Linear_sRGB;
        }
        SampleModel sampleModel = cachableRed.getSampleModel();
        switch (sampleModel.getNumBands()) {
            case 1: {
                return GraphicsUtil.Linear_sRGB;
            }
            case 2: {
                return GraphicsUtil.Linear_sRGB_Unpre;
            }
            case 3: {
                return GraphicsUtil.Linear_sRGB;
            }
        }
        return GraphicsUtil.Linear_sRGB_Unpre;
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed) {
        SampleModel sampleModel = cachableRed.getSampleModel();
        ColorModel colorModel = cachableRed.getColorModel();
        boolean bl = false;
        if (colorModel != null) {
            bl = colorModel.hasAlpha();
        } else {
            switch (sampleModel.getNumBands()) {
                case 1: 
                case 3: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (bl) {
            return new SinglePixelPackedSampleModel(3, sampleModel.getWidth(), sampleModel.getHeight(), new int[]{0xFF0000, 65280, 255, -16777216});
        }
        return new SinglePixelPackedSampleModel(3, sampleModel.getWidth(), sampleModel.getHeight(), new int[]{0xFF0000, 65280, 255});
    }

    static {
        int n = 0;
        while (n < 256) {
            double d = Any2LsRGBRed.sRGBToLsRGB((double)n * 0.00392156862745098);
            Any2LsRGBRed.sRGBToLsRGBLut[n] = (int)Math.round(d * 255.0);
            ++n;
        }
    }
}

