/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.api;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistenceapi.PersistenceScopeAccessor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class PersistenceScope {
    private static final Lookup.Result<PersistenceScopeProvider> providers = Lookup.getDefault().lookupResult(PersistenceScopeProvider.class);
    private final PersistenceScopeImplementation impl;

    public static PersistenceScope getPersistenceScope(FileObject fo) {
        Parameters.notNull("fo", fo);
        for (PersistenceScopeProvider provider : providers.allInstances()) {
            PersistenceScope persistenceScope = provider.findPersistenceScope(fo);
            if (persistenceScope == null) continue;
            return persistenceScope;
        }
        return null;
    }

    private PersistenceScope(PersistenceScopeImplementation impl) {
        this.impl = impl;
    }

    public FileObject getPersistenceXml() {
        return this.impl.getPersistenceXml();
    }

    public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String persistenceUnitName) {
        return this.impl.getEntityMappingsModel(persistenceUnitName);
    }

    public ClassPath getClassPath() {
        return this.impl.getClassPath();
    }

    static {
        PersistenceScopeAccessor.DEFAULT = new PersistenceScopeAccessor(){

            @Override
            public PersistenceScope createPersistenceScope(PersistenceScopeImplementation impl) {
                return new PersistenceScope(impl);
            }
        };
    }
}

