/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.errors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.URLCache;
import org.netbeans.modules.parsing.impl.indexing.errors.TaskProvider;
import org.netbeans.modules.parsing.impl.indexing.errors.Utilities;
import org.netbeans.modules.parsing.impl.indexing.implspi.CacheFolderProvider;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class TaskCache {
    private static final String ERR_EXT = "err";
    private static final String WARN_EXT = "warn";
    private static final String RELOCATION_FILE = "relocation.properties";
    private static final int VERSION = 1;
    private static final Logger LOG = Logger.getLogger(TaskCache.class.getName());
    private static final Pattern PATTERN = Pattern.compile("(\\d*),(\\d*)(?:-(\\d*),(\\d*))?");
    private static TaskCache theInstance;
    private ThreadLocal<TransactionContext> q = new ThreadLocal();

    private TaskCache() {
    }

    public static TaskCache getDefault() {
        if (null == theInstance) {
            theInstance = new TaskCache();
        }
        return theInstance;
    }

    private String getTaskType(ErrorsCache.ErrorKind k) {
        switch (k) {
            case ERROR: 
            case ERROR_NO_BADGE: {
                return "nb-tasklist-error";
            }
            case WARNING: {
                return "nb-tasklist-warning";
            }
        }
        return null;
    }

    private ErrorsCache.ReverseConvertor<Task> getTaskConvertor(FileObject file) {
        return (kind, range, message) -> {
            String severity = this.getTaskType(kind);
            if (null != severity) {
                return Task.create(file, severity, message, range.start().line());
            }
            return null;
        };
    }

    public List<Task> getErrors(FileObject file) {
        return this.getErrors(file, this.getTaskConvertor(file));
    }

    public <T> List<T> getErrors(FileObject file, ErrorsCache.ReverseConvertor<T> convertor) {
        LinkedList<T> result = new LinkedList<T>();
        result.addAll(this.getErrors(file, convertor, ERR_EXT));
        result.addAll(this.getErrors(file, convertor, WARN_EXT));
        return result;
    }

    private <T> List<T> getErrors(FileObject file, ErrorsCache.ReverseConvertor<T> convertor, String ext) {
        LOG.log(Level.FINE, "getErrors, file={0}, ext={1}", new Object[]{FileUtil.getFileDisplayName(file), ext});
        try {
            File input = this.computePersistentFile(file, ext);
            LOG.log(Level.FINE, "getErrors, error file={0}", input == null ? "null" : input.getAbsolutePath());
            if (input == null || !input.canRead()) {
                return Collections.emptyList();
            }
            input.getParentFile().mkdirs();
            return this.loadErrors(input, convertor);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, null, e);
            return Collections.emptyList();
        }
    }

    private <T> boolean dumpErrors(File output, Iterable<? extends T> errors, ErrorsCache.Convertor<T> convertor, boolean interestedInReturnValue) throws IOException {
        if (errors.iterator().hasNext()) {
            boolean existed = interestedInReturnValue && output.exists();
            output.getParentFile().mkdirs();
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));){
                for (T err : errors) {
                    pw.print(convertor.getKind(err).name());
                    pw.print(':');
                    ErrorsCache.Range range = convertor.getRange(err);
                    if (range != null) {
                        pw.print(String.format("%d,%d", range.start().line(), range.start().column()));
                        if (range.end() != null) {
                            pw.print(String.format("-%d,%d", range.end().line(), range.end().column()));
                        }
                    } else {
                        pw.print(convertor.getLineNumber(err));
                    }
                    pw.print(':');
                    String description = convertor.getMessage(err);
                    if (description == null || description.length() <= 0) continue;
                    description = description.replace("\\", "\\\\").replace("\n", "\\n").replace(":", "\\d");
                    pw.println(description);
                }
            }
            catch (FileNotFoundException fnf) {
                if (!output.getParentFile().canWrite()) {
                    LOG.log(Level.WARNING, "Cannot create cache file: {0}, verify file attributes.", output.getAbsolutePath());
                }
                throw Exceptions.attachMessage(fnf, String.format("exists: %b, read: %b, write: %b", output.getParentFile().exists(), output.getParentFile().canRead(), output.getParentFile().canWrite()));
            }
            return !existed;
        }
        return output.delete();
    }

    private <T> void separate(Iterable<? extends T> input, ErrorsCache.Convertor<T> convertor, List<T> errors, List<T> notErrors) {
        for (T err : input) {
            if (convertor.getKind(err) == ErrorsCache.ErrorKind.ERROR) {
                errors.add(err);
                continue;
            }
            notErrors.add(err);
        }
    }

    public <T> void dumpErrors(final URL root, final Indexable i, final Iterable<? extends T> errors, final ErrorsCache.Convertor<T> convertor) {
        try {
            this.refreshTransaction(new Mutex.ExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TaskCache.this.dumpErrors(TaskCache.this.q.get(), root, i, errors, convertor);
                    return null;
                }
            });
        }
        catch (IOException ex) {
            Exceptions.attachMessage(ex, "can't dump errors for: " + String.valueOf(i));
            Exceptions.printStackTrace(ex);
        }
    }

    private <T> void dumpErrors(TransactionContext c, URL root, Indexable i, Iterable<? extends T> errors, ErrorsCache.Convertor<T> convertor) throws IOException {
        assert (PathRegistry.noHostPart(root)) : root;
        File[] output = this.computePersistentFile(root, i);
        LinkedList trueErrors = new LinkedList();
        LinkedList notErrors = new LinkedList();
        this.separate(errors, convertor, trueErrors, notErrors);
        boolean modified = this.dumpErrors(output[0], trueErrors, convertor, true);
        this.dumpErrors(output[1], notErrors, convertor, false);
        URL currentFile = i.getURL();
        c.toRefresh.add(currentFile);
        if (modified) {
            Project p;
            currentFile = new URL(currentFile, ".");
            c.toRefresh.add(currentFile);
            String relativePath = i.getRelativePath();
            for (int depth = relativePath.split("/").length - 1; depth > 0; --depth) {
                currentFile = new URL(currentFile, "..");
                c.toRefresh.add(currentFile);
            }
            FileObject rootFO = URLMapper.findFileObject(root);
            if (rootFO != null && (p = FileOwnerQuery.getOwner(rootFO)) != null) {
                FileObject projectDirectory = p.getProjectDirectory();
                if (FileUtil.isParentOf(projectDirectory, rootFO)) {
                    for (FileObject currentFO = rootFO; currentFO != null && currentFO != projectDirectory; currentFO = currentFO.getParent()) {
                        c.toRefresh.add(currentFO.toURL());
                    }
                }
                c.toRefresh.add(projectDirectory.toURL());
            }
        }
        c.rootsToRefresh.add(root);
    }

    private <T> List<T> loadErrors(File input, ErrorsCache.ReverseConvertor<T> convertor) throws IOException {
        LinkedList<T> result = new LinkedList<T>();
        try (BufferedReader pw = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), StandardCharsets.UTF_8));){
            String line;
            while ((line = pw.readLine()) != null) {
                ErrorsCache.Range range;
                String[] parts = line.split(":");
                if (parts.length != 3) continue;
                ErrorsCache.ErrorKind kind = null;
                try {
                    kind = ErrorsCache.ErrorKind.valueOf(parts[0]);
                }
                catch (IllegalArgumentException iae) {
                    LOG.log(Level.FINE, "Invalid ErrorKind: {0}", line);
                }
                if (kind == null) continue;
                Matcher matcher = PATTERN.matcher(parts[1]);
                try {
                    if ("-1,-1".equals(parts[1])) {
                        range = new ErrorsCache.Range(new ErrorsCache.Position(-1, -1), null);
                    } else if (matcher.matches()) {
                        ErrorsCache.Position start = new ErrorsCache.Position(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
                        ErrorsCache.Position end = matcher.group(3) != null && matcher.group(4) != null ? new ErrorsCache.Position(Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4))) : null;
                        range = new ErrorsCache.Range(start, end);
                    } else {
                        int lineNumber = Integer.parseInt(parts[1]);
                        range = new ErrorsCache.Range(new ErrorsCache.Position(lineNumber, 1), null);
                    }
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.FINE, "Can't parse error line: " + line, ex);
                    continue;
                }
                String message = parts[2];
                T item = convertor.get(kind, range, message = message.replace("\\d", ":").replace("\\n", "\n").replace("\\\\", "\\"));
                if (item == null) continue;
                result.add(item);
            }
        }
        return result;
    }

    public List<URL> getAllFilesWithRecord(URL root) throws IOException {
        return this.getAllFilesWithRecord(root, false);
    }

    private List<URL> getAllFilesWithRecord(URL root, boolean onlyErrors) throws IOException {
        try {
            LinkedList<URL> result = new LinkedList<URL>();
            if (FileUtil.getArchiveFile(root) != null) {
                return result;
            }
            URI rootURI = root.toURI();
            File cacheRoot = TaskCache.getCacheRoot(root);
            URI cacheRootURI = BaseUtilities.toURI(cacheRoot);
            LinkedList<File> todo = new LinkedList<File>();
            todo.add(cacheRoot);
            while (!todo.isEmpty()) {
                File f = (File)todo.poll();
                assert (f != null);
                if (f.isFile()) {
                    String relative;
                    if (f.getName().endsWith(ERR_EXT)) {
                        relative = cacheRootURI.relativize(BaseUtilities.toURI(f)).getRawPath();
                        relative = relative.replaceAll(".err$", "");
                        result.add(rootURI.resolve(relative).toURL());
                    }
                    if (onlyErrors || !f.getName().endsWith(WARN_EXT)) continue;
                    relative = cacheRootURI.relativize(BaseUtilities.toURI(f)).getRawPath();
                    relative = relative.replaceAll(".warn$", "");
                    result.add(rootURI.resolve(relative).toURL());
                    continue;
                }
                File[] files = f.listFiles();
                if (files == null) continue;
                for (File children : files) {
                    todo.offer(children);
                }
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public List<URL> getAllFilesInError(URL root) throws IOException {
        return this.getAllFilesWithRecord(root, true);
    }

    public boolean isInError(FileObject file, boolean recursive) {
        LOG.log(Level.FINE, "file={0}, recursive={1}", new Object[]{file, recursive});
        if (file.isData()) {
            return !this.getErrors(file, this.getTaskConvertor(file), ERR_EXT).isEmpty();
        }
        try {
            ClassPath cp = Utilities.getSourceClassPathFor(file);
            if (cp == null) {
                return false;
            }
            FileObject root = cp.findOwnerRoot(file);
            if (root == null) {
                LOG.log(Level.FINE, "file={0} does not have a root on its own source classpath", file);
                return false;
            }
            String resourceName = cp.getResourceName(file, File.separatorChar, true);
            File cacheRoot = TaskCache.getCacheRoot(root.toURL(), true);
            if (cacheRoot == null) {
                return false;
            }
            File folder = new File(cacheRoot, resourceName);
            return this.folderContainsErrors(folder, recursive);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, null, e);
            return false;
        }
    }

    private boolean folderContainsErrors(File folder, boolean recursively) throws IOException {
        File[] errors = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".err") || name.endsWith(".err.rel");
            }
        });
        if (errors == null) {
            return false;
        }
        if (errors.length > 0) {
            return true;
        }
        if (!recursively) {
            return false;
        }
        File[] children = folder.listFiles();
        if (children == null) {
            return false;
        }
        for (File c : children) {
            if (!c.isDirectory() || !this.folderContainsErrors(c, recursively)) continue;
            return true;
        }
        return false;
    }

    private File[] computePersistentFile(URL root, Indexable i) throws IOException {
        String resourceName = i.getRelativePath();
        File cacheRoot = TaskCache.getCacheRoot(root);
        File errorCacheFile = TaskCache.computePersistentFile(cacheRoot, resourceName, ERR_EXT);
        File warningCacheFile = TaskCache.computePersistentFile(cacheRoot, resourceName, WARN_EXT);
        return new File[]{errorCacheFile, warningCacheFile};
    }

    private File computePersistentFile(FileObject file, String extension) throws IOException {
        ClassPath cp = Utilities.getSourceClassPathFor(file);
        if (cp == null) {
            return null;
        }
        FileObject root = cp.findOwnerRoot(file);
        if (root == null) {
            LOG.log(Level.FINE, "file={0} does not have a root on its own source classpath", file);
            return null;
        }
        String resourceName = cp.getResourceName(file, File.separatorChar, true);
        File cacheRoot = TaskCache.getCacheRoot(root.toURL());
        File cacheFile = TaskCache.computePersistentFile(cacheRoot, resourceName, extension);
        return cacheFile;
    }

    @NonNull
    private static File computePersistentFile(@NonNull File cacheRoot, @NonNull String resourceName, @NonNull String extension) {
        File candidate = new File(cacheRoot, resourceName + "." + extension);
        String nameComponent = candidate.getName();
        if (TaskCache.requiresRelocation(nameComponent)) {
            Properties relocation = TaskCache.loadRelocation(cacheRoot);
            String relName = relocation.getProperty(resourceName);
            if (relName == null) {
                relName = TaskCache.computeFreeName(relocation);
                relocation.setProperty(resourceName, relName);
                TaskCache.storeRelocation(cacheRoot, relocation);
            }
            candidate = new File(candidate.getParentFile(), String.format("%s.%s.rel", relName, extension));
        }
        return candidate;
    }

    private static boolean requiresRelocation(@NonNull String nameComponent) {
        return nameComponent.length() > 255;
    }

    @NonNull
    private static Properties loadRelocation(@NonNull File cacheRoot) {
        Properties result = new Properties();
        File relocationFile = new File(cacheRoot, RELOCATION_FILE);
        if (relocationFile.canRead()) {
            try (FileInputStream in = new FileInputStream(relocationFile);){
                result.load(in);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
        }
        return result;
    }

    private static void storeRelocation(@NonNull File cacheRoot, @NonNull Properties relocation) {
        File relocationFile = new File(cacheRoot, RELOCATION_FILE);
        try (FileOutputStream out = new FileOutputStream(relocationFile);){
            relocation.store(out, null);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace(ioe);
        }
    }

    @NonNull
    private static String computeFreeName(@NonNull Properties props) {
        int lastUsed = 0;
        for (Object value : props.values()) {
            int current = Integer.parseInt((String)value);
            if (lastUsed >= current) continue;
            lastUsed = current;
        }
        return Integer.toString(lastUsed + 1);
    }

    public <T> T refreshTransaction(Mutex.ExceptionAction<T> a) throws IOException {
        TransactionContext c = this.q.get();
        if (c == null) {
            c = new TransactionContext();
            this.q.set(c);
        }
        ++c.depth;
        try {
            T t = a.run();
            return t;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            if (--c.depth == 0) {
                TaskCache.doRefresh(c);
                this.q.set(null);
            }
        }
    }

    private static void doRefresh(TransactionContext c) {
        if (Utilities.isBadgesEnabled() && !c.toRefresh.isEmpty()) {
            Utilities.refreshAnnotations(c.toRefresh);
        }
        for (URL root : c.rootsToRefresh) {
            FileObject rootFO = URLCache.getInstance().findFileObject(root, true);
            if (rootFO == null) continue;
            TaskProvider.refresh(rootFO);
        }
    }

    private static File getCacheRoot(URL root) throws IOException {
        return TaskCache.getCacheRoot(root, false);
    }

    private static File getCacheRoot(URL root, boolean onlyIfExists) throws IOException {
        FileObject dataFolder = CacheFolder.getDataFolder(root, EnumSet.of(CacheFolderProvider.Kind.SOURCES, CacheFolderProvider.Kind.LIBRARIES), onlyIfExists ? CacheFolderProvider.Mode.EXISTENT : CacheFolderProvider.Mode.CREATE);
        if (dataFolder == null) {
            return null;
        }
        File cache = FileUtil.toFile(FileUtil.createFolder(dataFolder, "errors/1"));
        return cache;
    }

    private static final class TransactionContext {
        private int depth;
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        private Set<URL> toRefresh = new HashSet<URL>();
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        private Set<URL> rootsToRefresh = new HashSet<URL>();

        private TransactionContext() {
        }
    }
}

