/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.parsing.impl.indexing.errors.TaskCache;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;

public class ErrorsCache {
    public static <T> void setErrors(URL root, Indexable i, Iterable<? extends T> errors, Convertor<T> convertor) {
        TaskCache.getDefault().dumpErrors(root, i, errors, convertor);
    }

    public static boolean isInError(FileObject file, boolean recursive) {
        return TaskCache.getDefault().isInError(file, recursive);
    }

    public static Collection<? extends URL> getAllFilesInError(URL root) throws IOException {
        return Collections.unmodifiableCollection(TaskCache.getDefault().getAllFilesInError(root));
    }

    public static Collection<? extends URL> getAllFilesWithRecord(URL root) throws IOException {
        return Collections.unmodifiableCollection(TaskCache.getDefault().getAllFilesWithRecord(root));
    }

    public static <T> List<T> getErrors(FileObject file, ReverseConvertor<T> convertor) throws IOException {
        return Collections.unmodifiableList(TaskCache.getDefault().getErrors(file, convertor));
    }

    private ErrorsCache() {
    }

    public static interface Convertor<T> {
        public ErrorKind getKind(T var1);

        public int getLineNumber(T var1);

        public String getMessage(T var1);

        default public Range getRange(T t) {
            return null;
        }
    }

    public static interface ReverseConvertor<T> {
        public T get(ErrorKind var1, Range var2, String var3);
    }

    public static enum ErrorKind {
        ERROR,
        ERROR_NO_BADGE,
        WARNING;

    }

    public record Range(Position start, Position end) {
    }

    public record Position(int line, int column) {
    }
}

