/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.CatchTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TryTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.AnnotationValue;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.IntersectionType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.type.TypeVariable;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.jdk.UseSpecificCatchCustomizer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class UseSpecificCatch
implements CustomizerProvider {
    public static final String OPTION_EXCEPTION_LIST = "specificCatch.exceptions";
    static final String DEFAULT_EXCEPTION_LIST = "java.lang.Throwable, java.lang.Exception";
    public static final String SW_KEY = "UseSpecificCatch";

    @Override
    public JComponent getCustomizer(Preferences prefs) {
        return new UseSpecificCatchCustomizer(prefs);
    }

    /*
     * WARNING - void declaration
     */
    public static List<ErrorDescription> hint1(HintContext ctx) {
        if (ctx.getPath().getLeaf().getKind() != Tree.Kind.TRY) {
            return null;
        }
        TypeElement throwableEl = ctx.getInfo().getElements().getTypeElement("java.lang.Throwable");
        if (throwableEl == null) {
            return null;
        }
        TypeMirror throwableType = throwableEl.asType();
        TryTree tt = (TryTree)ctx.getPath().getLeaf();
        ArrayDeque<TypeMirror> process = new ArrayDeque<TypeMirror>(ctx.getInfo().getTreeUtilities().getUncaughtExceptions(new TreePath(ctx.getPath(), tt.getBlock())));
        HashMap<String, DeclaredType> declExceptions = new HashMap<String, DeclaredType>(process.size());
        block5: while (!process.isEmpty()) {
            TypeMirror e = (TypeMirror)process.poll();
            block0 : switch (e.getKind()) {
                case INTERSECTION: {
                    IntersectionType itt = (IntersectionType)e;
                    for (TypeMirror typeMirror : itt.getBounds()) {
                        if (!ctx.getInfo().getTypes().isAssignable(typeMirror, throwableType)) continue;
                        process.add(typeMirror);
                        break block0;
                    }
                    continue block5;
                }
                case TYPEVAR: {
                    TypeVariable tv = (TypeVariable)e;
                    if (tv.getUpperBound() != null) {
                        process.offer(tv.getUpperBound());
                    }
                    if (tv.getLowerBound() == null) break;
                    process.offer(tv.getLowerBound());
                    break;
                }
                case DECLARED: {
                    DeclaredType decl = (DeclaredType)e;
                    Element el = decl.asElement();
                    if (el.getKind() != ElementKind.CLASS) break;
                    declExceptions.putIfAbsent(((TypeElement)el).getQualifiedName().toString(), decl);
                }
            }
        }
        ArrayList fqns = new ArrayList(declExceptions.keySet());
        fqns.sort(null);
        ArrayList<TypeMirror> exceptions = new ArrayList<TypeMirror>(declExceptions.size());
        for (String string : fqns) {
            exceptions.add((TypeMirror)declExceptions.get(string));
        }
        StringTokenizer tukac = new StringTokenizer(ctx.getPreferences().get(OPTION_EXCEPTION_LIST, DEFAULT_EXCEPTION_LIST), ", ");
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(3);
        while (tukac.hasMoreTokens()) {
            String th = tukac.nextToken();
            TypeElement throwable = ctx.getInfo().getElements().getTypeElement(th);
            if (throwable == null) continue;
            arrayList.add(throwable.asType());
        }
        ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>(2);
        Collection<? extends TreePath> catchPaths = ctx.getMultiVariables().get("$catches$");
        String displayName = NbBundle.getMessage(UseSpecificCatch.class, "ERR_UseSpecificCatch");
        block9: for (TreePath treePath : catchPaths) {
            void var23_37;
            boolean source17;
            TreePath parameterPath;
            if (treePath.getLeaf().getKind() != Tree.Kind.CATCH) continue;
            CatchTree kec = (CatchTree)treePath.getLeaf();
            TypeMirror t = ctx.getInfo().getTrees().getTypeMirror(new TreePath(treePath, kec.getParameter().getType()));
            if (t == null || exceptions.remove(t) || !arrayList.contains(t) || UseSpecificCatch.assignsTo(ctx, parameterPath = new TreePath(treePath, kec.getParameter()), Collections.singletonList(new TreePath(treePath, kec.getBlock())))) continue;
            TypeElement sw = ctx.getInfo().getElements().getTypeElement(SuppressWarnings.class.getName());
            Element catchParamElement = ctx.getInfo().getTrees().getElement(parameterPath);
            if (sw != null && catchParamElement != null) {
                for (AnnotationMirror annotationMirror : catchParamElement.getAnnotationMirrors()) {
                    if (!sw.equals(annotationMirror.getAnnotationType().asElement())) continue;
                    for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
                        if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("value") || !(((AnnotationValue)entry.getValue()).getValue() instanceof List)) continue;
                        for (AnnotationValue av : NbCollections.checkedListByCopy((List)((AnnotationValue)entry.getValue()).getValue(), AnnotationValue.class, false)) {
                            if (!SW_KEY.equals(av.getValue())) continue;
                            continue block9;
                        }
                    }
                }
            }
            LinkedHashSet<TypeMirrorHandle<TypeMirror>> exceptionHandles = new LinkedHashSet<TypeMirrorHandle<TypeMirror>>();
            Object var21_26 = null;
            for (TypeMirror typeMirror : exceptions) {
                if (!ctx.getInfo().getTypes().isSubtype(typeMirror, t)) continue;
                TypeMirror typeMirror2 = typeMirror;
                exceptionHandles.add(TypeMirrorHandle.create(typeMirror));
            }
            boolean bl = source17 = ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) >= 0;
            if (exceptionHandles.isEmpty()) continue;
            if (exceptionHandles.size() > 1) {
                if (source17) {
                    Fix fix = new FixImpl(ctx.getInfo(), treePath, exceptionHandles).toEditorFix();
                } else {
                    Fix fix = new SplitExceptionInCatches(ctx.getInfo(), treePath, exceptionHandles, null).toEditorFix();
                }
            } else {
                void var21_27;
                Fix fix = new SplitExceptionInCatches(ctx.getInfo(), treePath, exceptionHandles, ctx.getInfo().getTypeUtilities().getTypeName((TypeMirror)var21_27, new TypeUtilities.TypeNameOptions[0]).toString()).toEditorFix();
            }
            descs.add(ErrorDescriptionFactory.forName(ctx, kec.getParameter().getType(), displayName, new Fix[]{var23_37}));
        }
        return descs;
    }

    public static boolean assignsTo(final HintContext ctx, TreePath variable, Iterable<? extends TreePath> statements) {
        final Element tEl = ctx.getInfo().getTrees().getElement(variable);
        if (tEl == null || tEl.getKind() != ElementKind.EXCEPTION_PARAMETER) {
            return true;
        }
        final boolean[] result = new boolean[1];
        for (TreePath treePath : statements) {
            new ErrorAwareTreePathScanner<Void, Void>(){

                @Override
                public Void visitAssignment(AssignmentTree node, Void p) {
                    if (tEl.equals(ctx.getInfo().getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable())))) {
                        result[0] = true;
                    }
                    return (Void)super.visitAssignment(node, p);
                }
            }.scan(treePath, (Void)null);
        }
        return result[0];
    }

    public static class SplitExceptionInCatches
    extends JavaFix {
        private Collection<TypeMirrorHandle<TypeMirror>> newTypes;
        private final String singleName;

        public SplitExceptionInCatches(CompilationInfo info, TreePath tp, Collection<TypeMirrorHandle<TypeMirror>> newTypes, String singleName) {
            super(info, tp);
            this.newTypes = newTypes;
            this.singleName = singleName;
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(UseSpecificCatch.class, this.singleName != null ? "FIX_UseSpecificCatchSingle" : "FIX_UseSpecificCatchSplit", this.singleName);
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            CatchTree oldTree = (CatchTree)ctx.getPath().getLeaf();
            TryTree oldTry = (TryTree)ctx.getPath().getParentPath().getLeaf();
            WorkingCopy wcopy = ctx.getWorkingCopy();
            GeneratorUtilities gen = GeneratorUtilities.get(wcopy);
            TreeMaker mk = wcopy.getTreeMaker();
            int index = oldTry.getCatches().indexOf(oldTree);
            TryTree result = mk.removeTryCatch(oldTry, index);
            for (TypeMirrorHandle<TypeMirror> h : this.newTypes) {
                TypeMirror m = h.resolve(wcopy);
                if (m == null || m.getKind() != TypeKind.DECLARED) continue;
                CatchTree branch = mk.Catch(mk.Variable(oldTree.getParameter().getModifiers(), oldTree.getParameter().getName(), mk.Type(m), oldTree.getParameter().getInitializer()), oldTree.getBlock());
                gen.copyComments(oldTree, branch, true);
                result = mk.insertTryCatch(result, index++, branch);
            }
            wcopy.rewrite(oldTry, result);
        }
    }

    public static final class FixImpl
    extends JavaFix {
        private final Set<TypeMirrorHandle<TypeMirror>> exceptionHandles;

        public FixImpl(CompilationInfo info, TreePath tryStatement, Set<TypeMirrorHandle<TypeMirror>> exceptionHandles) {
            super(info, tryStatement);
            this.exceptionHandles = exceptionHandles;
        }

        @Override
        protected String getText() {
            return NbBundle.getMessage(UseSpecificCatch.class, "FIX_UseSpecificCatch");
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            LinkedList<Tree> exceptions = new LinkedList<Tree>();
            for (TypeMirrorHandle<TypeMirror> h : this.exceptionHandles) {
                TypeMirror tm = h.resolve(wc);
                if (tm == null) {
                    return;
                }
                exceptions.add(wc.getTreeMaker().Type(tm));
            }
            VariableTree excVar = ((CatchTree)tp.getLeaf()).getParameter();
            wc.rewrite(excVar.getType(), wc.getTreeMaker().UnionType(exceptions));
        }
    }
}

