/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sampler;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.sampler.Bundle;
import org.netbeans.modules.sampler.Sampler;
import org.netbeans.modules.sampler.SamplesOutputStream;
import org.netbeans.modules.sampler.SelfSampleVFS;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

final class InternalSampler
extends Sampler {
    private static final String SAMPLER_NAME = "selfsampler";
    private static final String FILE_NAME = "selfsampler.npss";
    private static final String UNKNOWN_MIME_TYPE = "content/unknown";
    private static final String X_DEBUG_ARG = "-Xdebug";
    private static final String JDWP_DEBUG_ARG = "-agentlib:jdwp";
    private static final String JDWP_DEBUG_ARG_PREFIX = "-agentlib:jdwp=";
    private static final Logger LOGGER = Logger.getLogger(InternalSampler.class.getName());
    private static Boolean debugMode;
    private static String lastReason;
    private ProgressHandle progress;

    static InternalSampler createInternalSampler(String key) {
        if (SamplesOutputStream.isSupported() && InternalSampler.isRunMode()) {
            return new InternalSampler(key);
        }
        return null;
    }

    private static synchronized boolean isDebugged() {
        if (debugMode == null) {
            debugMode = Boolean.FALSE;
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            List<String> args = runtime.getInputArguments();
            if (args.contains(X_DEBUG_ARG)) {
                debugMode = Boolean.TRUE;
            } else if (args.contains(JDWP_DEBUG_ARG)) {
                debugMode = Boolean.TRUE;
            } else {
                for (String arg : args) {
                    if (!arg.startsWith(JDWP_DEBUG_ARG_PREFIX)) continue;
                    debugMode = Boolean.TRUE;
                    break;
                }
            }
        }
        return debugMode;
    }

    private static boolean isRunMode() {
        boolean runMode = true;
        String reason = null;
        if (InternalSampler.isDebugged()) {
            reason = "running in debug mode";
            runMode = false;
        }
        if (runMode) {
            try {
                Class.forName("org.netbeans.lib.profiler.server.ProfilerServer", false, ClassLoader.getSystemClassLoader());
                reason = "running under profiler";
                runMode = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!runMode && !reason.equals(lastReason)) {
            LOGGER.log(Level.INFO, "Slowness detector disabled - {0}", reason);
        }
        lastReason = reason;
        return runMode;
    }

    InternalSampler(String thread) {
        super(thread);
    }

    @Override
    protected void printStackTrace(Throwable ex) {
        Exceptions.printStackTrace(ex);
    }

    @Override
    protected void saveSnapshot(byte[] arr) throws IOException {
        SelfSampleVFS fs;
        FileObject fo;
        File outFile = File.createTempFile(SAMPLER_NAME, ".npss");
        File userDir = Places.getUserDirectory();
        File gestures = null;
        outFile = FileUtil.normalizeFile(outFile);
        this.writeToFile(outFile, arr);
        if (userDir != null) {
            gestures = new File(new File(new File(userDir, "var"), "log"), "uigestures");
        }
        if (UNKNOWN_MIME_TYPE.equals((fo = (fs = gestures != null && gestures.exists() ? new SelfSampleVFS(new String[]{FILE_NAME, "selfsampler.log"}, new File[]{outFile, gestures}) : new SelfSampleVFS(new String[]{FILE_NAME}, new File[]{outFile})).findResource(FILE_NAME)).getMIMEType())) {
            String msg = Bundle.SelfSamplerAction_SavedFile(outFile.getAbsolutePath());
            DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(msg));
        } else {
            DataObject dobj = DataObject.find(fo);
            dobj.getLookup().lookup(Openable.class).open();
        }
    }

    private void writeToFile(File file, byte[] arr) {
        try {
            FileOutputStream fstream = new FileOutputStream(file);
            fstream.write(arr);
            fstream.close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    @Override
    ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    @Override
    void openProgress(int steps) {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        this.progress = ProgressHandleFactory.createHandle(Bundle.Save_Progress());
        this.progress.start(steps);
    }

    @Override
    void closeProgress() {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        this.progress.finish();
        this.progress = null;
    }

    @Override
    void progress(int i) {
        if (EventQueue.isDispatchThread()) {
            return;
        }
        if (this.progress != null) {
            this.progress.progress(i);
        }
    }
}

