/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.init;

import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.init.ConfigurableComponentInitializer;
import org.apache.nifi.init.ReflectionUtils;
import org.apache.nifi.mock.MockComponentLogger;
import org.apache.nifi.mock.MockConfigurationContext;
import org.apache.nifi.mock.MockControllerServiceInitializationContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.reporting.InitializationException;

public class ControllerServiceInitializer
implements ConfigurableComponentInitializer {
    private final ExtensionManager extensionManager;

    public ControllerServiceInitializer(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Override
    public void initialize(ConfigurableComponent component) throws InitializationException {
        ControllerService controllerService = (ControllerService)component;
        MockControllerServiceInitializationContext context = new MockControllerServiceInitializationContext();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), context.getIdentifier());){
            controllerService.initialize((ControllerServiceInitializationContext)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teardown(ConfigurableComponent component) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(this.extensionManager, component.getClass(), component.getIdentifier());){
            ControllerService controllerService = (ControllerService)component;
            MockComponentLogger logger = new MockComponentLogger();
            MockConfigurationContext context = new MockConfigurationContext();
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, controllerService, logger, context);
        }
        finally {
            this.extensionManager.removeInstanceClassLoader(component.getIdentifier());
        }
    }
}

