/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

public class PGSetParamContext
extends AbstractNiFiCommand<VoidResult> {
    public PGSetParamContext() {
        super("pg-set-param-context", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Sets the parameter context bound to the given process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        ProcessGroupEntity pgEntity = pgClient.getProcessGroup(pgId);
        ParameterContextReferenceEntity parameterContextReference = new ParameterContextReferenceEntity();
        parameterContextReference.setId(paramContextId);
        ProcessGroupDTO updatedDTO = new ProcessGroupDTO();
        updatedDTO.setId(pgId);
        updatedDTO.setParameterContext(parameterContextReference);
        ProcessGroupEntity updatedEntity = new ProcessGroupEntity();
        updatedEntity.setId(pgId);
        updatedEntity.setComponent(updatedDTO);
        updatedEntity.setRevision(pgEntity.getRevision());
        pgClient.updateProcessGroup(updatedEntity);
        return VoidResult.getInstance();
    }
}

