/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.fontencodingpane;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.debugger.fontencodingpane.FontEncodingView;
import org.apache.pdfbox.debugger.fontencodingpane.FontPane;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;

class SimpleFont
extends FontPane {
    private static final Log LOG = LogFactory.getLog(SimpleFont.class);
    public static final String NO_GLYPH = "None";
    private final FontEncodingView view;
    private int totalAvailableGlyph = 0;

    SimpleFont(PDSimpleFont font) throws IOException {
        Object[][] tableData = this.getGlyphs(font);
        double[] yBounds = this.getYBounds(tableData, 3);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("Font", font.getName());
        attributes.put("Encoding", SimpleFont.getEncodingName(font));
        attributes.put("Glyphs", Integer.toString(this.totalAvailableGlyph));
        attributes.put("Standard 14", Boolean.toString(font.isStandard14()));
        attributes.put("Embedded", Boolean.toString(font.isEmbedded()));
        this.view = new FontEncodingView(tableData, attributes, new String[]{"Code", "Glyph Name", "Unicode Character", "Glyph"}, yBounds);
    }

    private Object[][] getGlyphs(PDSimpleFont font) throws IOException {
        Object[][] glyphs = new Object[256][4];
        for (int index = 0; index <= 255; ++index) {
            glyphs[index][0] = index;
            String unicode = font.toUnicode(index);
            if (unicode == null) {
                unicode = String.valueOf((char)index);
            }
            if (font.getEncoding().contains(index) || unicode != null) {
                String glyphName = font.getEncoding().getName(index);
                glyphs[index][1] = glyphName;
                glyphs[index][2] = unicode;
                try {
                    glyphs[index][3] = ((PDVectorFont)font).getPath(index);
                }
                catch (IOException ex) {
                    LOG.error((Object)("Couldn't render code " + index + " ('" + glyphName + "') of font " + font.getName()), (Throwable)ex);
                    glyphs[index][3] = new GeneralPath();
                }
                ++this.totalAvailableGlyph;
                continue;
            }
            glyphs[index][1] = NO_GLYPH;
            glyphs[index][2] = NO_GLYPH;
            glyphs[index][3] = font.getPath(".notdef");
        }
        return glyphs;
    }

    static String getEncodingName(PDSimpleFont font) {
        if (font.getEncoding() == null) {
            return "(null)";
        }
        return font.getClass().getSimpleName() + " / " + font.getEncoding().getEncodingName();
    }

    @Override
    public JPanel getPanel() {
        return this.view.getPanel();
    }
}

