/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameters;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CmdUsageFormatter
extends DefaultUsageFormatter {
    private Set<String> deprecatedCommands = new HashSet<String>();
    private final JCommander commander;

    public CmdUsageFormatter(JCommander commander) {
        super(commander);
        this.commander = commander;
    }

    public void appendCommands(StringBuilder out, int indentCount, int descriptionIndent, String indent) {
        out.append(indent + "  Commands:\n");
        for (Map.Entry commands : this.commander.getRawCommands().entrySet()) {
            JCommander.ProgramName progName;
            String dispName;
            Object arg = ((JCommander)commands.getValue()).getObjects().get(0);
            Parameters p = arg.getClass().getAnnotation(Parameters.class);
            if (p != null && p.hidden() || this.deprecatedCommands.contains(dispName = (progName = (JCommander.ProgramName)commands.getKey()).getDisplayName())) continue;
            String description = indent + CmdUsageFormatter.s((int)4) + dispName + CmdUsageFormatter.s((int)6) + this.getCommandDescription(progName.getName());
            this.wrapDescription(out, indentCount + descriptionIndent, description);
            out.append("\n");
            JCommander jc = this.commander.findCommandByAlias(progName.getName());
            jc.getUsageFormatter().usage(out, indent + CmdUsageFormatter.s((int)6));
            out.append("\n");
        }
    }

    public void addDeprecatedCommand(String command) {
        this.deprecatedCommands.add(command);
    }

    public void removeDeprecatedCommand(String command) {
        this.deprecatedCommands.remove(command);
    }

    public void clearDeprecatedCommand() {
        this.deprecatedCommands.clear();
    }
}

