/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.internal;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.util.Collections;
import org.apache.sling.commons.metrics.Gauge;
import org.apache.sling.commons.metrics.internal.BundleMetricsMapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GaugeManager
implements ServiceTrackerCustomizer<Gauge, GaugeImpl>,
Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MetricRegistry registry;
    private final BundleMetricsMapper mapper;
    private final BundleContext bundleContext;
    private ServiceTracker<Gauge, GaugeImpl> tracker;

    public GaugeManager(BundleContext context, MetricRegistry registry, BundleMetricsMapper mapper) {
        this.registry = registry;
        this.mapper = mapper;
        this.bundleContext = context;
        this.tracker = new ServiceTracker(context, Gauge.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public GaugeImpl addingService(ServiceReference<Gauge> reference) {
        String name = (String)reference.getProperty("name");
        if (name == null) {
            this.log.warn("A {} service is registered without [{}] property. This Gauge would not be registered with MetricsRegistry", reference, (Object)"name");
            return null;
        }
        Gauge gauge = (Gauge)this.bundleContext.getService(reference);
        GaugeImpl gaugeImpl = new GaugeImpl(name, gauge);
        this.register(reference, gaugeImpl);
        return gaugeImpl;
    }

    public void modifiedService(ServiceReference<Gauge> reference, GaugeImpl service) {
        String name = (String)reference.getProperty("name");
        if (name == null) {
            return;
        }
        if (!name.equals(service.name)) {
            this.unregister(service);
            service.name = name;
            this.register(reference, service);
        }
    }

    public void removedService(ServiceReference<Gauge> reference, GaugeImpl service) {
        this.unregister(service);
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    private void unregister(GaugeImpl service) {
        this.mapper.unregister(Collections.singleton(service.name));
    }

    private void register(ServiceReference<Gauge> reference, GaugeImpl gaugeImpl) {
        this.mapper.addMapping(gaugeImpl.name, reference.getBundle());
        this.registry.register(gaugeImpl.name, (Metric)gaugeImpl);
    }

    public static class GaugeImpl
    implements com.codahale.metrics.Gauge {
        String name;
        final Gauge gauge;

        public GaugeImpl(String name, Gauge gauge) {
            this.name = name;
            this.gauge = gauge;
        }

        public Object getValue() {
            return this.gauge.getValue();
        }
    }
}

