/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.internal;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.Gauge;
import org.apache.sling.commons.metrics.Histogram;
import org.apache.sling.commons.metrics.Meter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.commons.metrics.internal.BundleMetricsMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

class InternalMetricsServiceFactory
implements ServiceFactory<MetricsService> {
    private final MetricsService delegate;
    private final BundleMetricsMapper metricsMapper;

    public InternalMetricsServiceFactory(MetricsService delegate, BundleMetricsMapper metricsMapper) {
        this.delegate = delegate;
        this.metricsMapper = metricsMapper;
    }

    public MetricsService getService(Bundle bundle, ServiceRegistration<MetricsService> registration) {
        return new BundleMetricService(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<MetricsService> registration, MetricsService service) {
        if (service instanceof BundleMetricService) {
            ((BundleMetricService)service).unregister();
        }
    }

    private class BundleMetricService
    implements MetricsService {
        private final Bundle bundle;
        private Set<String> registeredNames = Collections.newSetFromMap(new ConcurrentHashMap());

        public BundleMetricService(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public Timer timer(String name) {
            this.addMapping(name);
            return InternalMetricsServiceFactory.this.delegate.timer(name);
        }

        @Override
        public Histogram histogram(String name) {
            this.addMapping(name);
            return InternalMetricsServiceFactory.this.delegate.histogram(name);
        }

        @Override
        public Counter counter(String name) {
            this.addMapping(name);
            return InternalMetricsServiceFactory.this.delegate.counter(name);
        }

        @Override
        public Meter meter(String name) {
            this.addMapping(name);
            return InternalMetricsServiceFactory.this.delegate.meter(name);
        }

        @Override
        public <A> A adaptTo(Class<A> type) {
            return InternalMetricsServiceFactory.this.delegate.adaptTo(type);
        }

        void unregister() {
            InternalMetricsServiceFactory.this.metricsMapper.unregister(this.registeredNames);
        }

        private void addMapping(String name) {
            InternalMetricsServiceFactory.this.metricsMapper.addMapping(name, this.bundle);
            this.registeredNames.add(name);
        }

        @Override
        public <T> Gauge<T> gauge(String name, Supplier<T> supplier) {
            this.addMapping(name);
            return InternalMetricsServiceFactory.this.delegate.gauge(name, supplier);
        }

        @Override
        public boolean unregister(String name) {
            return InternalMetricsServiceFactory.this.metricsMapper.unregister(Collections.singleton(name));
        }
    }
}

