/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import jakarta.servlet.Filter;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.FilterPredicate;
import org.apache.sling.engine.impl.filter.FilterProcessorMBeanImpl;

public class SlingFilterChainHelper {
    private static final FilterHandle[] EMPTY_FILTER_ARRAY = new FilterHandle[0];
    private final SortedSet<FilterHandle> filterList = new TreeSet<FilterHandle>();
    private volatile FilterHandle[] filters = EMPTY_FILTER_ARRAY;

    public synchronized void addFilter(Filter filter, FilterPredicate pattern, long filterId, int order, String orderSource, FilterProcessorMBeanImpl mbean) {
        this.filterList.add(new FilterHandle(filter, pattern, filterId, order, orderSource, mbean));
        this.filters = this.getFiltersInternal();
    }

    public synchronized boolean removeFilterById(long filterId) {
        Iterator fi = this.filterList.iterator();
        while (fi.hasNext()) {
            FilterHandle test = (FilterHandle)fi.next();
            if (test.getFilterId() != filterId) continue;
            fi.remove();
            this.filters = this.getFiltersInternal();
            return true;
        }
        return false;
    }

    public FilterHandle[] getFilters() {
        return this.filters;
    }

    private FilterHandle[] getFiltersInternal() {
        if (this.filterList.isEmpty()) {
            return EMPTY_FILTER_ARRAY;
        }
        return this.filterList.toArray(new FilterHandle[this.filterList.size()]);
    }
}

