/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.Dependency;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.JcrPackage;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageId;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageProperties;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.VaultPackage;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl.JcrWorkspaceFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;

public class JcrRegisteredPackage
implements RegisteredPackage {
    private JcrPackage pkg;
    private VaultPackage vltPkg;

    public JcrRegisteredPackage(JcrPackage pkg) throws IOException, RepositoryException {
        this.pkg = pkg;
        this.vltPkg = pkg.getPackage();
    }

    public JcrPackage getJcrPackage() {
        return this.pkg;
    }

    @Override
    @NotNull
    public PackageId getId() {
        return this.vltPkg.getId();
    }

    @Override
    @NotNull
    public VaultPackage getPackage() throws IOException {
        return this.vltPkg;
    }

    @Override
    public boolean isInstalled() {
        try {
            return this.pkg.isInstalled();
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public long getSize() {
        return this.pkg.getSize();
    }

    @Override
    @Nullable
    public Calendar getInstallationTime() {
        try {
            JcrPackageDefinition def = this.pkg.getDefinition();
            return def == null ? null : def.getLastUnpacked();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        this.vltPkg.close();
        this.vltPkg = null;
        this.pkg.close();
        this.pkg = null;
    }

    @Override
    public int compareTo(RegisteredPackage o) {
        return this.getId().compareTo(o.getId());
    }

    @Override
    public Dependency[] getDependencies() {
        return this.vltPkg.getDependencies();
    }

    @Override
    public WorkspaceFilter getWorkspaceFilter() {
        try {
            return JcrWorkspaceFilter.loadFilter(this.pkg.getDefNode());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public PackageProperties getPackageProperties() throws IOException {
        return this.getPackage().getProperties();
    }
}

