/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.schema;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.request.builder.SlingHttpServletResponseResult;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.graphql.api.SchemaProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SchemaProvider.class}, immediate=true, property={"service.ranking:Integer=-2147482648", "service.description=Apache Sling Scripting GraphQL SchemaProvider", "service.vendor=The Apache Software Foundation"})
public class DefaultSchemaProvider
implements SchemaProvider {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final int SERVICE_RANKING = -2147482648;
    public static final String SCHEMA_EXTENSION = "GQLschema";
    public static final String DEFAULT_SCHEMA = "";
    @Reference
    private ServletResolver servletResolver;

    @Override
    public String getSchema(Resource r, String[] selectors) throws IOException {
        SlingHttpServletRequest req = Builders.newRequestBuilder((Resource)r).withSelectors(selectors).withExtension(SCHEMA_EXTENSION).build();
        SlingHttpServletResponseResult response = Builders.newResponseBuilder().build();
        try {
            Servlet servlet = this.servletResolver.resolveServlet(req);
            if (servlet != null) {
                servlet.service((ServletRequest)req, (ServletResponse)response);
            }
        }
        catch (ServletException e) {
            this.LOGGER.error("Unable to retrieve a GraphQL Schema for {}.", (Object)r.getPath());
        }
        this.LOGGER.debug("Getting GraphQL Schema for {}: {}", (Object)r.getPath(), (Object)req);
        if (response.getStatus() == 200) {
            return response.getOutputAsString();
        }
        return DEFAULT_SCHEMA;
    }
}

