/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.annotations;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.junit.Activator;
import org.apache.sling.junit.TestObjectProcessor;
import org.apache.sling.junit.impl.AnnotationsProcessor;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingAnnotationsTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger log = LoggerFactory.getLogger(SlingAnnotationsTestRunner.class);
    private TestObjectProcessor top;
    private List<Object> tests = new ArrayList<Object>();

    public SlingAnnotationsTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    @Override
    protected Object createTest() throws Exception {
        BundleContext ctx = Activator.getBundleContext();
        ServiceReference ref = ctx == null ? null : ctx.getServiceReference(TestObjectProcessor.class.getName());
        TestObjectProcessor testObjectProcessor = this.top = ref == null ? null : (TestObjectProcessor)ctx.getService(ref);
        if (this.top == null) {
            log.info("No TestObjectProcessor service available, annotations will not be processed");
            return super.createTest();
        }
        log.debug("Using TestObjectProcessor {}", (Object)this.top);
        Object test = this.top.process(super.createTest());
        this.tests.add(test);
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RunNotifier notifier) {
        try {
            super.run(notifier);
        }
        finally {
            if (this.top instanceof AnnotationsProcessor) {
                AnnotationsProcessor ap = (AnnotationsProcessor)this.top;
                for (int i = 0; i < this.tests.size(); ++i) {
                    ap.cleanupTest(this.tests.get(i));
                }
            }
        }
    }
}

