/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.launchpad.base.impl.DirectoryUtil;
import org.apache.sling.launchpad.base.impl.bootstrapcommands.BootstrapCommandFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;

class BootstrapInstaller {
    private static final String SCHEME = "slinginstall:";
    private static final String PATH_RESOURCES = "resources/";
    static final String PATH_CORE_BUNDLES = "resources/corebundles";
    static final String PATH_BUNDLES = "resources/bundles";
    static final String BND_LAST_MODIFIED_HEADER = "Bnd-LastModified";
    private static final int STARTLEVEL_CORE_BUNDLES = 1;
    private static final int STARTLEVEL_BUNDLES = 0;
    private static final int STARTLEVEL_NONE = -1;
    public static final String BOOTSTRAP_CMD_FILENAME = "sling_bootstrap.txt";
    private final Logger logger;
    private final LaunchpadContentProvider resourceProvider;
    private final BundleContext bundleContext;
    private final StartupMode startupMode;

    BootstrapInstaller(BundleContext bundleContext, Logger logger, LaunchpadContentProvider resourceProvider, StartupMode startupMode) {
        this.startupMode = startupMode;
        this.logger = logger;
        this.resourceProvider = resourceProvider;
        this.bundleContext = bundleContext;
    }

    boolean install() throws IOException {
        String launchpadHome = this.bundleContext.getProperty("sling.launchpad");
        if (launchpadHome == null) {
            launchpadHome = this.bundleContext.getProperty("sling.home");
        }
        File slingStartupDir = this.getSlingStartupDir(launchpadHome);
        BootstrapCommandFile cmd = new BootstrapCommandFile(this.logger, new File(launchpadHome, BOOTSTRAP_CMD_FILENAME));
        boolean requireRestart = cmd.execute(this.bundleContext);
        boolean shouldInstall = false;
        String fpblString = this.bundleContext.getProperty("org.apache.sling.launchpad.force.package.bundle.loading");
        if (Boolean.valueOf(fpblString).booleanValue()) {
            shouldInstall = true;
        } else {
            boolean bl = shouldInstall = this.startupMode != StartupMode.RESTART;
        }
        if (shouldInstall) {
            String dpblString = this.bundleContext.getProperty("org.apache.sling.launchpad.disable.package.bundle.loading");
            Boolean disablePackageBundleLoading = Boolean.valueOf(dpblString);
            if (disablePackageBundleLoading.booleanValue()) {
                this.logger.log(3, "Package bundle loading is disabled so no bundles will be installed from the resources location in the sling jar/war");
            } else {
                Iterator<String> resources = this.resourceProvider.getChildren(PATH_BUNDLES);
                while (resources.hasNext()) {
                    int startLevel;
                    String path = resources.next();
                    if (!path.endsWith("/") || (startLevel = this.getStartLevel(path = path.substring(0, path.length() - 1))) == -1) continue;
                    this.copyBundles(slingStartupDir, path, startLevel);
                }
                this.copyBundles(slingStartupDir, PATH_CORE_BUNDLES, 1);
                this.copyBundles(slingStartupDir, PATH_BUNDLES, 0);
            }
            Bundle[] bundles = this.bundleContext.getBundles();
            HashMap<String, Bundle> bySymbolicName = new HashMap<String, Bundle>();
            for (int i = 0; i < bundles.length; ++i) {
                bySymbolicName.put(bundles[i].getSymbolicName(), bundles[i]);
            }
            LinkedList<Bundle> installed = new LinkedList<Bundle>();
            requireRestart |= this.installBundles(slingStartupDir, bySymbolicName, installed);
            this.startBundles(installed);
        }
        if (requireRestart) {
            this.logger.log(3, "Framework extension(s) have been updated, restarting framework after startup has completed");
        }
        return requireRestart;
    }

    private File getSlingStartupDir(String slingHome) {
        File slingHomeDir = new File(slingHome);
        File slingHomeStartupDir = this.getOrCreateDirectory(slingHomeDir, "startup");
        return slingHomeStartupDir;
    }

    private File getOrCreateDirectory(File parentDir, String subDirName) {
        File slingHomeStartupDir = new File(parentDir, subDirName).getAbsoluteFile();
        if (slingHomeStartupDir.exists()) {
            if (!(slingHomeStartupDir.isDirectory() && parentDir.canRead() && parentDir.canWrite())) {
                throw new IllegalStateException("Fatal error in bootstrap: Cannot find accessible existing sling.homestartup directory: " + slingHomeStartupDir);
            }
        } else if (!slingHomeStartupDir.mkdirs()) {
            throw new IllegalStateException("Sling Home " + slingHomeStartupDir + " cannot be created as a directory");
        }
        return slingHomeStartupDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBundles(File slingStartupDir, String parent, int startLevel) {
        if (startLevel < 0) {
            startLevel = 0;
        }
        File startUpLevelDir = null;
        Iterator<String> res = this.resourceProvider.getChildren(parent);
        while (res.hasNext()) {
            InputStream ins;
            String path = res.next();
            if (!DirectoryUtil.isBundle(path) || (ins = this.resourceProvider.getResourceAsStream(path)) == null) continue;
            try {
                if (startUpLevelDir == null) {
                    startUpLevelDir = this.getOrCreateDirectory(slingStartupDir, String.valueOf(startLevel));
                }
                String bundleFileName = BootstrapInstaller.extractFileName(path);
                File bundleFile = new File(startUpLevelDir, bundleFileName);
                try {
                    BootstrapInstaller.copyStreamToFile(ins, bundleFile);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failure copying file from " + path + " to startup dir (" + startUpLevelDir + ") and name (" + bundleFileName + "): " + e, e);
                }
            }
            finally {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyStreamToFile(InputStream fromStream, File toFile) throws IOException {
        if (fromStream == null || toFile == null) {
            throw new IllegalArgumentException("fromStream and toFile must not be null");
        }
        if (!toFile.exists()) {
            toFile.createNewFile();
        }
        try (FileOutputStream out = new FileOutputStream(toFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = fromStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    private boolean installBundles(File slingStartupDir, Map<String, Bundle> currentBundles, List<Bundle> installed) {
        File[] directories;
        boolean requireRestart = false;
        for (File levelDir : directories = slingStartupDir.listFiles(DirectoryUtil.DIRECTORY_FILTER)) {
            File[] bundleFiles;
            int startLevel;
            String dirName = levelDir.getName();
            try {
                startLevel = Integer.decode(dirName);
            }
            catch (NumberFormatException e) {
                startLevel = 0;
            }
            for (File bundleFile : bundleFiles = levelDir.listFiles(DirectoryUtil.BUNDLE_FILE_FILTER)) {
                requireRestart |= this.installBundle(bundleFile, startLevel, currentBundles, installed);
            }
        }
        return requireRestart;
    }

    private boolean installBundle(File bundleJar, int startLevel, Map<String, Bundle> currentBundles, List<Bundle> installed) {
        boolean requireRestart;
        FileInputStream ins;
        Manifest manifest = this.getManifest(bundleJar);
        if (manifest == null) {
            this.logger.log(1, "Ignoring " + bundleJar + ": Cannot read manifest");
            return false;
        }
        String symbolicName = BootstrapInstaller.getBundleSymbolicName(manifest);
        if (symbolicName == null) {
            this.logger.log(1, "Ignoring " + bundleJar + ": Missing " + "Bundle-SymbolicName" + " in manifest");
            return false;
        }
        Bundle installedBundle = currentBundles.get(symbolicName);
        if (this.ignore(installedBundle, startLevel, manifest)) {
            this.logger.log(3, "Ignoring " + bundleJar + ": More recent version already installed");
            return false;
        }
        try {
            ins = new FileInputStream(bundleJar);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (installedBundle != null) {
            requireRestart = this.isSystemBundleFragment(installedBundle);
            try {
                installedBundle.update(ins);
                this.logger.log(3, "Bundle " + installedBundle.getSymbolicName() + " updated from " + bundleJar);
                if (startLevel > 0) {
                    installedBundle.adapt(BundleStartLevel.class).setStartLevel(startLevel);
                }
            }
            catch (BundleException be) {
                this.logger.log(1, "Bundle update from " + bundleJar + " failed", be);
            }
        } else {
            requireRestart = false;
            String path = bundleJar.getPath();
            String location = SCHEME + path.substring(path.lastIndexOf(47) + 1);
            try {
                Bundle theBundle = this.bundleContext.installBundle(location, ins);
                this.logger.log(3, "Bundle " + theBundle.getSymbolicName() + " installed from " + location);
                installed.add(theBundle);
                if (startLevel > 0) {
                    theBundle.adapt(BundleStartLevel.class).setStartLevel(startLevel);
                }
            }
            catch (BundleException be) {
                this.logger.log(1, "Bundle installation from " + location + " failed", be);
            }
        }
        return requireRestart;
    }

    private void startBundles(List<Bundle> bundles) {
        for (Bundle bundle : bundles) {
            try {
                if (BootstrapInstaller.isFragment(bundle)) continue;
                bundle.start();
            }
            catch (BundleException be) {
                this.logger.log(1, "Bundle " + bundle.getSymbolicName() + " could not be started", be);
            }
        }
    }

    private int getStartLevel(String path) {
        String name = path.substring(path.lastIndexOf(47) + 1);
        try {
            int level = Integer.parseInt(name);
            if (level >= 0) {
                return level;
            }
            this.logger.log(1, "Illegal Runlevel for " + path + ", ignoring");
        }
        catch (NumberFormatException nfe) {
            this.logger.log(3, "Folder " + path + " does not denote start level, ignoring");
        }
        return -1;
    }

    private boolean isSystemBundleFragment(Bundle installedBundle) {
        String fragmentHeader = installedBundle.getHeaders().get("Fragment-Host");
        return fragmentHeader != null && fragmentHeader.indexOf("extension") > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(File jar) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar, false);
            Manifest manifest = jarFile.getManifest();
            return manifest;
        }
        catch (IOException e) {
            this.logger.log(2, "Could not get inputstream from file (" + jar + "):" + e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    static String getBundleSymbolicName(Manifest manifest) {
        return manifest.getMainAttributes().getValue("Bundle-SymbolicName");
    }

    private boolean ignore(Bundle installedBundle, int startLevel, Manifest manifest) {
        int installedBundleStartLevel;
        String installedVersionProp;
        Version installedVersion;
        if (installedBundle == null) {
            return false;
        }
        String versionProp = manifest.getMainAttributes().getValue("Bundle-Version");
        Version newVersion = Version.parseVersion(versionProp);
        if (newVersion.equals(installedVersion = Version.parseVersion(installedVersionProp = installedBundle.getHeaders().get("Bundle-Version"))) && installedVersionProp.endsWith("SNAPSHOT") && this.isNewerSnapshot(installedBundle, manifest)) {
            this.logger.log(3, "Forcing upgrade of SNAPSHOT bundle: " + installedBundle.getSymbolicName());
            return false;
        }
        if (newVersion.equals(installedVersion) && startLevel != (installedBundleStartLevel = installedBundle.adapt(BundleStartLevel.class).getStartLevel())) {
            return false;
        }
        return newVersion.compareTo(installedVersion) <= 0;
    }

    private static boolean isFragment(Bundle bundle) {
        Dictionary<String, String> headerMap = bundle.getHeaders();
        return headerMap.get("Fragment-Host") != null;
    }

    private boolean isNewerSnapshot(Bundle installedBundle, Manifest manifest) {
        long installedTime;
        String installedDate = installedBundle.getHeaders().get(BND_LAST_MODIFIED_HEADER);
        String toBeInstalledDate = manifest.getMainAttributes().getValue(BND_LAST_MODIFIED_HEADER);
        if (installedDate == null) {
            this.logger.log(4, String.format("Currently installed bundle %s doesn't have a %s header", installedBundle.getSymbolicName(), BND_LAST_MODIFIED_HEADER));
            return true;
        }
        if (toBeInstalledDate == null) {
            this.logger.log(4, String.format("Candidate bundle %s doesn't have a %s header", installedBundle.getSymbolicName(), BND_LAST_MODIFIED_HEADER));
            return true;
        }
        long toBeInstalledTime = 0L;
        try {
            installedTime = Long.valueOf(installedDate);
        }
        catch (NumberFormatException e) {
            this.logger.log(4, String.format("%s header of currently installed bundle %s isn't parseable.", BND_LAST_MODIFIED_HEADER, installedBundle.getSymbolicName()));
            return true;
        }
        try {
            toBeInstalledTime = Long.valueOf(toBeInstalledDate);
        }
        catch (NumberFormatException e) {
            this.logger.log(4, String.format("%s header of candidate bundle %s isn't parseable.", BND_LAST_MODIFIED_HEADER, installedBundle.getSymbolicName()));
            return true;
        }
        return toBeInstalledTime > installedTime;
    }

    static boolean isBlank(String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    static String extractFileName(String path) {
        if (BootstrapInstaller.isBlank(path)) {
            throw new IllegalArgumentException("Invalid blank path specified, cannot extract filename: " + path);
        }
        path = path.replace(File.separatorChar, '/');
        String name = "";
        int slashPos = path.lastIndexOf(47);
        if (slashPos == -1) {
            name = path;
        } else if (path.length() > slashPos + 1) {
            name = path.substring(slashPos + 1);
        }
        if (BootstrapInstaller.isBlank(name)) {
            throw new IllegalArgumentException("Invalid path, no filename found: " + path);
        }
        return name;
    }
}

