/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.bundle;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.type.ResourceType;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnitCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.TypeReference;

class BundledRenderUnitCapabilityImpl
implements BundledRenderUnitCapability {
    private final Set<ResourceType> resourceTypes;
    private final String path;
    private final List<String> selectors;
    private final String extension;
    private final String method;
    private final String extendedResourceType;
    private final String scriptEngineName;
    private final String scriptExtension;

    private BundledRenderUnitCapabilityImpl(@NotNull Set<ResourceType> resourceTypes, @Nullable String path, @NotNull List<String> selectors, @Nullable String extension, @Nullable String method, @Nullable String extendedResourceType, @Nullable String scriptEngineName, @Nullable String scriptExtension) {
        this.resourceTypes = resourceTypes;
        this.path = path;
        this.selectors = selectors;
        this.extension = extension;
        this.method = method;
        this.extendedResourceType = extendedResourceType;
        this.scriptEngineName = scriptEngineName;
        this.scriptExtension = scriptExtension;
    }

    @NotNull
    public Set<ResourceType> getResourceTypes() {
        return Collections.unmodifiableSet(this.resourceTypes);
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @NotNull
    public List<String> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    @Nullable
    public String getExtendedResourceType() {
        return this.extendedResourceType;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    @Nullable
    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    @Nullable
    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public int hashCode() {
        return Objects.hash(this.resourceTypes, this.path, this.selectors, this.extension, this.method, this.extendedResourceType, this.scriptEngineName, this.scriptExtension);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BundledRenderUnitCapability) {
            BundledRenderUnitCapability other = (BundledRenderUnitCapability)obj;
            return Objects.equals(this.resourceTypes, other.getResourceTypes()) && Objects.equals(this.path, other.getPath()) && Objects.equals(this.selectors, other.getSelectors()) && Objects.equals(this.extension, other.getExtension()) && Objects.equals(this.method, other.getMethod()) && Objects.equals(this.extendedResourceType, other.getExtendedResourceType()) && Objects.equals(this.scriptEngineName, other.getScriptEngineName()) && Objects.equals(this.scriptExtension, other.getScriptExtension());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(BundledRenderUnitCapability.class.getSimpleName()).append("[");
        if (!this.resourceTypes.isEmpty()) {
            sb.append("sling.servlet.resourceTypes").append("=").append(this.resourceTypes);
        }
        if (!this.selectors.isEmpty()) {
            sb.append("; ").append("sling.servlet.selectors").append("=").append(this.selectors);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.extension)) {
            sb.append("; ").append("sling.servlet.extensions").append("=").append(this.extension);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.method)) {
            sb.append("; ").append("sling.servlet.methods").append("=").append(this.method);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.path)) {
            sb.append("; ").append("sling.servlet.paths").append("=").append(this.path);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.extendedResourceType)) {
            sb.append("; ").append("extends").append("=").append(this.extendedResourceType);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.scriptEngineName)) {
            sb.append("; ").append("scriptEngine").append("=").append(this.scriptEngineName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.scriptExtension)) {
            sb.append("; ").append("scriptExtension").append("=").append(this.scriptExtension);
        }
        sb.append("]");
        return sb.toString();
    }

    public static BundledRenderUnitCapability fromBundleCapability(@NotNull BundleCapability capability) {
        Map attributes = capability.getAttributes();
        LinkedHashSet<ResourceType> resourceTypes = new LinkedHashSet<ResourceType>();
        String[] capabilityResourceTypes = (String[])Converters.standardConverter().convert(attributes.get("sling.servlet.resourceTypes")).to(String[].class);
        Version version = (Version)attributes.get("version");
        for (String rt : capabilityResourceTypes) {
            if (version == null) {
                resourceTypes.add(ResourceType.parseResourceType((String)rt));
                continue;
            }
            resourceTypes.add(ResourceType.parseResourceType((String)(rt + "/" + version)));
        }
        return new BundledRenderUnitCapabilityImpl(resourceTypes, (String)attributes.get("sling.servlet.paths"), (List)Converters.standardConverter().convert(attributes.get("sling.servlet.selectors")).to((TypeReference)new TypeReference<List<String>>(){}), (String)attributes.get("sling.servlet.extensions"), (String)attributes.get("sling.servlet.methods"), (String)attributes.get("extends"), (String)attributes.get("scriptEngine"), (String)attributes.get("scriptExtension"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<ResourceType> resourceTypes;
        private String path;
        private List<String> selectors;
        private String extension;
        private String method;
        private String extendedResourceType;
        private String scriptEngineName;
        private String scriptExtension;

        public Builder withResourceTypes(@NotNull Set<ResourceType> resourceTypes) {
            this.resourceTypes = resourceTypes;
            return this;
        }

        public Builder withPath(@Nullable String path) {
            this.path = path;
            return this;
        }

        public Builder withSelectors(@NotNull List<String> selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder withExtension(@Nullable String extension) {
            this.extension = extension;
            return this;
        }

        public Builder withMethod(@Nullable String method) {
            this.method = method;
            return this;
        }

        public Builder withExtendedResourceType(@Nullable String extendedResourceType) {
            this.extendedResourceType = extendedResourceType;
            return this;
        }

        public Builder withScriptEngineName(@Nullable String scriptEngineName) {
            this.scriptEngineName = scriptEngineName;
            return this;
        }

        public Builder withScriptEngineExtension(@Nullable String scriptExtension) {
            this.scriptExtension = scriptExtension;
            return this;
        }

        public Builder fromCapability(@NotNull BundledRenderUnitCapability capability) {
            this.extendedResourceType = capability.getExtendedResourceType();
            this.extension = capability.getExtension();
            this.method = capability.getMethod();
            this.path = capability.getPath();
            this.resourceTypes = capability.getResourceTypes();
            this.scriptEngineName = capability.getScriptEngineName();
            this.scriptExtension = capability.getScriptExtension();
            this.selectors = capability.getSelectors();
            return this;
        }

        public BundledRenderUnitCapability build() {
            return new BundledRenderUnitCapabilityImpl(this.resourceTypes, this.path, this.selectors, this.extension, this.method, this.extendedResourceType, this.scriptEngineName, this.scriptExtension);
        }
    }
}

