/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.tapestry5.internal.plastic.MethodInvocationBundle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodInvocation;

public abstract class AbstractMethodInvocation
implements MethodInvocation {
    private final Object instance;
    private final InstanceContext instanceContext;
    private final MethodInvocationBundle bundle;
    private int adviceIndex;
    private Exception checkedException;

    protected AbstractMethodInvocation(Object instance, InstanceContext instanceContext, MethodInvocationBundle bundle) {
        this.instance = instance;
        this.instanceContext = instanceContext;
        this.bundle = bundle;
    }

    protected void clearCheckedException() {
        this.checkedException = null;
    }

    @Override
    public void rethrow() {
        if (this.checkedException != null) {
            throw new RuntimeException(this.checkedException);
        }
    }

    @Override
    public boolean didThrowCheckedException() {
        return this.checkedException != null;
    }

    @Override
    public <T extends Throwable> T getCheckedException(Class<T> exceptionType) {
        assert (exceptionType != null);
        if (exceptionType.isInstance(this.checkedException)) {
            return (T)((Throwable)exceptionType.cast(this.checkedException));
        }
        return null;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public InstanceContext getInstanceContext() {
        return this.instanceContext;
    }

    @Override
    public MethodInvocation proceed() {
        if (this.adviceIndex == this.bundle.advice.length) {
            this.proceedToAdvisedMethod();
        } else {
            this.bundle.advice[this.adviceIndex++].advise(this);
        }
        return this;
    }

    @Override
    public MethodInvocation setCheckedException(Exception exception) {
        this.checkedException = exception;
        return this;
    }

    @Override
    public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.getMethod().getAnnotation(annotationType);
    }

    @Override
    public Method getMethod() {
        return this.bundle.getMethod(this.getInstance());
    }

    protected abstract void proceedToAdvisedMethod();
}

