// Copyright 2008, 2009 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.beaneditor;

import org.apache.tapestry5.ioc.annotations.UseWith;
import org.apache.tapestry5.ioc.annotations.AnnotationUseContext;

import java.lang.annotation.*;


/**
 * An annotation that may be placed on a JavaBean to re-order the properties.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@UseWith(AnnotationUseContext.BEAN)
public @interface ReorderProperties
{
    /**
     * A comma-separated list of property names.  Properties will be re-ordered as specified, with any unmentioned
     * property names ordered to the end of the list.
     */
    String value();
}
