/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CollectionSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class TraversalMetricsSerializer
extends SimpleTypeSerializer<TraversalMetrics> {
    private static final CollectionSerializer collectionSerializer = new CollectionSerializer(DataType.LIST);

    public TraversalMetricsSerializer() {
        super(DataType.TRAVERSALMETRICS);
    }

    @Override
    protected TraversalMetrics readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Long durationNanos = context.readValue(buffer, Long.class, false);
        ArrayList<MutableMetrics> metrics = new ArrayList<MutableMetrics>(collectionSerializer.readValue(buffer, context));
        return new DefaultTraversalMetrics(durationNanos, metrics);
    }

    @Override
    protected void writeValue(TraversalMetrics value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value.getDuration(TimeUnit.NANOSECONDS), buffer, false);
        collectionSerializer.writeValue(value.getMetrics(), buffer, context);
    }
}

