/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.PageContext;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.xml.utils.QName;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XObjectFactory;

public class JSTLVariableStack
extends VariableStack {
    private static final String PARAM_PREFIX = "param";
    private static final String HEADER_PREFIX = "header";
    private static final String COOKIE_PREFIX = "cookie";
    private static final String INITPARAM_PREFIX = "initParam";
    private static final String PAGE_PREFIX = "pageScope";
    private static final String REQUEST_PREFIX = "requestScope";
    private static final String SESSION_PREFIX = "sessionScope";
    private static final String APP_PREFIX = "applicationScope";
    private static final Map<String, Scope> SCOPES = new HashMap<String, Scope>(8);
    private final PageContext pageContext;

    public JSTLVariableStack(PageContext pageContext) {
        super(2);
        this.pageContext = pageContext;
    }

    public XObject getVariableOrParam(XPathContext xctxt, QName qname) throws TransformerException {
        String name;
        String prefix = qname.getNamespaceURI();
        Object value = this.getValue(prefix, name = qname.getLocalPart());
        if (value == null) {
            StringBuilder var = new StringBuilder();
            var.append('$');
            if (prefix != null) {
                var.append(prefix);
                var.append(':');
            }
            var.append(name);
            throw new TransformerException(Resources.getMessage("XPATH_UNABLE_TO_RESOLVE_VARIABLE", var.toString()));
        }
        return XObjectFactory.create((Object)value, (XPathContext)xctxt);
    }

    private Object getValue(String prefix, String name) {
        if (prefix == null) {
            return this.pageContext.findAttribute(name);
        }
        Scope scope = SCOPES.get(prefix);
        switch (scope) {
            case PARAM: {
                return this.pageContext.getRequest().getParameter(name);
            }
            case HEADER: {
                return ((HttpServletRequest)this.pageContext.getRequest()).getHeader(name);
            }
            case COOKIE: {
                Cookie[] cookies = ((HttpServletRequest)this.pageContext.getRequest()).getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if (!cookie.getName().equals(name)) continue;
                        return cookie.getValue();
                    }
                }
                return null;
            }
            case INITPARAM: {
                return this.pageContext.getServletContext().getInitParameter(name);
            }
            case PAGE: {
                return this.pageContext.getAttribute(name, 1);
            }
            case REQUEST: {
                return this.pageContext.getAttribute(name, 2);
            }
            case SESSION: {
                return this.pageContext.getAttribute(name, 3);
            }
            case APPLICATION: {
                return this.pageContext.getAttribute(name, 4);
            }
        }
        throw new AssertionError();
    }

    static {
        SCOPES.put(PARAM_PREFIX, Scope.PARAM);
        SCOPES.put(HEADER_PREFIX, Scope.HEADER);
        SCOPES.put(COOKIE_PREFIX, Scope.COOKIE);
        SCOPES.put(INITPARAM_PREFIX, Scope.INITPARAM);
        SCOPES.put(PAGE_PREFIX, Scope.PAGE);
        SCOPES.put(REQUEST_PREFIX, Scope.REQUEST);
        SCOPES.put(SESSION_PREFIX, Scope.SESSION);
        SCOPES.put(APP_PREFIX, Scope.APPLICATION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Scope {
        PARAM,
        HEADER,
        COOKIE,
        INITPARAM,
        PAGE,
        REQUEST,
        SESSION,
        APPLICATION;

    }
}

