/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BasicModule;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJep247;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.ModuleFinder;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.tool.ModuleLocationHandler;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;

public class ClasspathJsr199
extends ClasspathLocation {
    private static final String NO_PATH = "";
    private final Set<JavaFileObject.Kind> fileTypes;
    private final JavaFileManager fileManager;
    private final JavaFileManager.Location location;
    private FileSystem.Classpath jrt;
    private Supplier<Parser> parserSupplier;
    private String encoding;
    private Set<JavaFileObject> initialJavaFileObjects;

    public ClasspathJsr199(JavaFileManager file, JavaFileManager.Location location) {
        super(null, null);
        this.fileManager = file;
        this.location = location;
        this.fileTypes = location == StandardLocation.SOURCE_PATH ? Collections.singleton(JavaFileObject.Kind.SOURCE) : Collections.singleton(JavaFileObject.Kind.CLASS);
    }

    public ClasspathJsr199(FileSystem.Classpath jrt, JavaFileManager file, JavaFileManager.Location location) {
        this(file, location);
        this.jrt = jrt;
    }

    public ClasspathJsr199(ClasspathJep247 older, JavaFileManager file, JavaFileManager.Location location) {
        this(file, location);
        this.jrt = older;
    }

    public ClasspathJsr199(JavaFileManager fileManager, JavaFileManager.Location location, Set<JavaFileObject> initialJavaFileObjects, Supplier<Parser> parserSupplier) {
        this(fileManager, location);
        this.initialJavaFileObjects = initialJavaFileObjects;
        this.parserSupplier = parserSupplier;
    }

    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter problemReporter) {
        return null;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String aQualifiedBinaryFileName, boolean asBinaryOnly) {
        char[] answerModule;
        JavaFileObject jfo;
        String qualifiedBinaryFileName;
        block10: {
            String className;
            block9: {
                if (this.jrt != null) {
                    return this.jrt.findClass(typeName, qualifiedPackageName, moduleName, aQualifiedBinaryFileName, asBinaryOnly);
                }
                qualifiedBinaryFileName = File.separatorChar == '/' ? aQualifiedBinaryFileName : aQualifiedBinaryFileName.replace(File.separatorChar, '/');
                int lastDot = qualifiedBinaryFileName.lastIndexOf(46);
                className = lastDot < 0 ? qualifiedBinaryFileName : qualifiedBinaryFileName.substring(0, lastDot);
                jfo = null;
                try {
                    jfo = this.fileManager.getJavaFileForInput(this.location, className, this.fileTypes.iterator().next());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (jfo != null) break block9;
                return null;
            }
            char[] cArray = answerModule = this.module != null ? this.module.name() : null;
            if (jfo.getKind() == JavaFileObject.Kind.CLASS) {
                ClassFileReader reader = ClasspathJsr199.readJavaClass(jfo, qualifiedBinaryFileName);
                return reader != null && className.equals(new String(reader.getName())) ? new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName), answerModule) : null;
            }
            if (this.initialJavaFileObjects == null || !this.initialJavaFileObjects.contains(jfo)) break block10;
            return null;
        }
        try {
            CompilationUnit cu = ClasspathJsr199.readCompilationUnit(jfo, this.encoding);
            cu.module = answerModule;
            return new NameEnvironmentAnswer(cu, this.fetchAccessRestriction(qualifiedBinaryFileName), answerModule);
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public char[][][] findTypeNames(String aQualifiedPackageName, String moduleName) {
        if (this.jrt != null) {
            return this.jrt.findTypeNames(aQualifiedPackageName, moduleName);
        }
        String qualifiedPackageName = File.separatorChar == '/' ? aQualifiedPackageName : aQualifiedPackageName.replace(File.separatorChar, '/');
        Iterable<JavaFileObject> files = null;
        try {
            files = this.fileManager.list(this.location, qualifiedPackageName, this.fileTypes, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (files == null) {
            return null;
        }
        ArrayList<char[][]> answers = new ArrayList<char[][]>();
        char[][] packageName = CharOperation.splitOn(File.separatorChar, qualifiedPackageName.toCharArray());
        for (JavaFileObject file : files) {
            int indexOfDot;
            String fileName = file.toUri().getPath();
            int last = fileName.lastIndexOf(47);
            if (last <= 0 || (indexOfDot = fileName.lastIndexOf(46)) == -1) continue;
            String typeName = fileName.substring(last + 1, indexOfDot);
            answers.add(CharOperation.arrayConcat(packageName, typeName.toCharArray()));
        }
        int size = answers.size();
        if (size != 0) {
            char[][][] result = new char[size][][];
            answers.toArray((T[])result);
            return result;
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
        if (this.jrt != null) {
            this.jrt.initialize();
        } else {
            JavaFileManager.Location location = this.location;
            if (location instanceof ModuleLocationHandler.LocationWrapper) {
                ModuleLocationHandler.LocationWrapper wrapper = (ModuleLocationHandler.LocationWrapper)location;
                for (Path path : wrapper.getPaths()) {
                    File file = path.toFile();
                    IModule mod = ModuleFinder.scanForModule(this, file, null, true, null);
                    if (mod == null) continue;
                    return;
                }
            } else if (this.location == StandardLocation.SOURCE_PATH) {
                for (JavaFileObject javaFileObject : this.fileManager.list(this.location, NO_PATH, Collections.singleton(JavaFileObject.Kind.SOURCE), false)) {
                    if (!javaFileObject.getName().equals("module-info.java")) continue;
                    this.module = ClasspathJsr199.extractModuleFromFileObject(javaFileObject, this.parserSupplier, this, this.encoding);
                    return;
                }
            } else {
                for (JavaFileObject javaFileObject : this.fileManager.list(this.location, NO_PATH, Collections.singleton(JavaFileObject.Kind.CLASS), false)) {
                    if (!javaFileObject.getName().equals("module-info.class")) continue;
                    this.module = ClasspathJsr199.extractModuleFromFileObject(javaFileObject, null, this, this.encoding);
                    return;
                }
            }
        }
    }

    @Override
    public void acceptModule(IModule mod) {
        if (this.jrt != null) {
            return;
        }
        this.module = mod;
    }

    @Override
    public char[][] getModulesDeclaringPackage(String aQualifiedPackageName, String moduleName) {
        if (this.jrt != null) {
            return this.jrt.getModulesDeclaringPackage(aQualifiedPackageName, moduleName);
        }
        String qualifiedPackageName = File.separatorChar == '/' ? aQualifiedPackageName : aQualifiedPackageName.replace(File.separatorChar, '/');
        boolean result = false;
        try {
            Iterable<JavaFileObject> files = this.fileManager.list(this.location, qualifiedPackageName, this.fileTypes, false);
            Iterator<JavaFileObject> f = files.iterator();
            if (f.hasNext()) {
                result = true;
            } else {
                files = this.fileManager.list(this.location, qualifiedPackageName, this.fileTypes, true);
                f = files.iterator();
                if (f.hasNext()) {
                    result = true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.singletonModuleNameIf(result);
    }

    @Override
    public char[][] listPackages() {
        HashSet<String> packageNames = new HashSet<String>();
        try {
            for (JavaFileObject fileObject : this.fileManager.list(this.location, NO_PATH, this.fileTypes, true)) {
                String name = fileObject.getName();
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash == -1) continue;
                packageNames.add(name.substring(0, lastSlash).replace('/', '.'));
            }
            char[][] result = new char[packageNames.size()][];
            int i = 0;
            for (String s : packageNames) {
                result[i++] = s.toCharArray();
            }
            return result;
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR_CHAR;
        }
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        if (this.jrt != null) {
            return this.jrt.hasCompilationUnit(qualifiedPackageName, moduleName);
        }
        return false;
    }

    @Override
    public void reset() {
        try {
            super.reset();
            this.fileManager.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.jrt != null) {
            this.jrt.reset();
        }
    }

    public String toString() {
        return "Classpath for Jsr 199 JavaFileManager: " + String.valueOf(this.location);
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            this.normalizedPath = this.getPath().toCharArray();
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = this.location.getName();
        }
        return this.path;
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public boolean hasAnnotationFileFor(String qualifiedTypeName) {
        return false;
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> limitModules) {
        if (this.jrt != null) {
            return this.jrt.getModuleNames(limitModules);
        }
        if (this.module != null) {
            return Collections.singletonList(String.valueOf(this.module.name()));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasModule() {
        if (this.jrt != null) {
            return this.jrt.hasModule();
        }
        return super.hasModule();
    }

    @Override
    public IModule getModule(char[] name) {
        if (this.jrt != null) {
            return this.jrt.getModule(name);
        }
        return super.getModule(name);
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, false);
    }

    public static ClassFileReader readJavaClass(JavaFileObject jfo, String name) throws ClassFormatException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = jfo.openInputStream();){
            return ClassFileReader.read(inputStream.readAllBytes(), name);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static CompilationUnit readCompilationUnit(JavaFileObject jfo, String encoding) throws IOException {
        return new CompilationUnit(jfo.getCharContent(false).toString().toCharArray(), jfo.getName(), encoding);
    }

    public static IModule extractModuleFromFileObject(JavaFileObject javaFileObject, Supplier<Parser> parserSupplier, FileSystem.Classpath pathEntry, String encoding) {
        try {
            switch (javaFileObject.getKind()) {
                case SOURCE: {
                    return ClasspathJsr199.extractModuleFromSource(javaFileObject, parserSupplier.get(), pathEntry, encoding);
                }
                case CLASS: {
                    return ClasspathJsr199.extractModuleFromClass(javaFileObject, pathEntry);
                }
            }
            throw new IllegalArgumentException("Unexpected kind " + String.valueOf((Object)javaFileObject.getKind()));
        }
        catch (IOException e) {
            String error = "Failed to read module from " + String.valueOf(pathEntry);
            if (JRTUtil.PROPAGATE_IO_ERRORS) {
                throw new IllegalStateException(error, e);
            }
            System.err.println(error);
            e.printStackTrace();
        }
        catch (ClassFormatException e) {
            e.printStackTrace();
        }
        return null;
    }

    static IModule extractModuleFromSource(JavaFileObject javaFileObject, Parser parser, FileSystem.Classpath pathEntry, String encoding) throws IOException {
        CompilationResult compilationResult;
        CompilationUnit cu = ClasspathJsr199.readCompilationUnit(javaFileObject, encoding);
        CompilationUnitDeclaration unit = parser.parse(cu, compilationResult = new CompilationResult(cu, 0, 1, 10));
        if (unit.isModuleInfo() && unit.moduleDeclaration != null) {
            cu.module = unit.moduleDeclaration.moduleName;
            return new BasicModule(unit.moduleDeclaration, pathEntry);
        }
        return null;
    }

    static IModule extractModuleFromClass(JavaFileObject javaFileObject, FileSystem.Classpath pathEntry) throws ClassFormatException, IOException {
        IBinaryModule module;
        ClassFileReader reader = ClasspathJsr199.readJavaClass(javaFileObject, "module-info.class");
        if (reader != null && (module = reader.getModuleDeclaration()) != null) {
            return reader.getModuleDeclaration();
        }
        return null;
    }
}

