/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.commons.io.IOUtils;

class CacheEntry {
    private static final StringManager sm = StringManager.getManager(CacheEntry.class);
    private final String hash;
    private final boolean exists;
    private final File cacheFile;
    private final File tempFile;

    CacheEntry(String hash, boolean exists, File cacheFile, File tempFile) {
        this.hash = hash;
        this.exists = exists;
        this.cacheFile = cacheFile;
        this.tempFile = tempFile;
    }

    public boolean exists() {
        return this.exists;
    }

    public String getHash() {
        return this.hash;
    }

    public void copyToDestination(OutputStream dest) throws IOException {
        if (!this.exists) {
            throw new IllegalStateException(sm.getString("cacheEntry.copyNotExist"));
        }
        try (FileInputStream fis = new FileInputStream(this.cacheFile);){
            IOUtils.copy((InputStream)fis, dest);
        }
    }

    public OutputStream beginStore() throws IOException {
        return new FileOutputStream(this.tempFile);
    }

    public void commitStore() throws IOException {
        if (!this.tempFile.exists()) {
            throw new IOException(sm.getString("cacheEntry.tempNotExist", this.tempFile));
        }
        File parentDir = this.cacheFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!this.tempFile.renameTo(this.cacheFile)) {
            throw new IOException(sm.getString("cacheEntry.tempRenameFail", this.tempFile, this.cacheFile));
        }
    }

    public long getFileSize() {
        return this.cacheFile.length();
    }

    public void rollbackStore() {
        if (this.tempFile.exists()) {
            this.tempFile.delete();
        }
    }
}

